/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0016\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u001cH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddLoopLabelFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "loop", "jumpExpression", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtLoopExpression;Lorg/jetbrains/kotlin/psi/KtElement;)V", "getJumpExpression", "()Lorg/jetbrains/kotlin/psi/KtElement;", "collectUsedLabels", "", "", "element", "getFamilyName", "getText", "getUniqueLabelName", "existingNames", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Companion", "idea"})
public final class AddLoopLabelFix
extends KotlinQuickFixAction<KtLoopExpression> {
    @NotNull
    private final KtElement jumpExpression;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Add label to loop";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return super.isAvailable(project, editor, file);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Set<String> usedLabels = this.collectUsedLabels((KtElement)this.getElement());
        String labelName = this.getUniqueLabelName((Collection<String>)usedLabels);
        KtExpression jumpWithLabel = new KtPsiFactory(project).createExpression(this.jumpExpression.getText() + "@" + labelName);
        this.jumpExpression.replace((PsiElement)jumpWithLabel);
        KtLabeledExpression labeledLoopExpression = new KtPsiFactory(project).createLabeledExpression(labelName);
        KtExpression ktExpression = labeledLoopExpression.getBaseExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        ktExpression.replace((PsiElement)this.getElement());
        ((KtLoopExpression)this.getElement()).replace((PsiElement)labeledLoopExpression);
    }

    private final Set<String> collectUsedLabels(KtElement element2) {
        HashSet usedLabels = SetsKt.hashSetOf((Object[])new String[0]);
        element2.acceptChildren(new KtTreeVisitorVoid(usedLabels){
            final /* synthetic */ HashSet $usedLabels;

            public void visitLabeledExpression(@NotNull KtLabeledExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitLabeledExpression(expression2);
                String string = expression2.getLabelName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                this.$usedLabels.add(string);
            }
            {
                this.$usedLabels = $captured_local_variable$0;
            }
        });
        Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParents((PsiElement)element2);
        for (Object element$iv : $receiver$iv) {
            PsiElement it = (PsiElement)element$iv;
            if (!(it instanceof KtLabeledExpression)) continue;
            String string = ((KtLabeledExpression)it).getLabelName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            usedLabels.add(string);
        }
        return usedLabels;
    }

    private final String getUniqueLabelName(Collection<String> existingNames) {
        int index2 = 0;
        String result2 = "loop";
        while (existingNames.contains(result2)) {
            result2 = "loop" + ++index2;
        }
        return result2;
    }

    @NotNull
    public final KtElement getJumpExpression() {
        return this.jumpExpression;
    }

    public AddLoopLabelFix(@NotNull KtLoopExpression loop, @NotNull KtElement jumpExpression) {
        Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
        Intrinsics.checkParameterIsNotNull((Object)jumpExpression, (String)"jumpExpression");
        super((PsiElement)loop);
        this.jumpExpression = jumpExpression;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddLoopLabelFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtElement ktElement;
            KtElement element2;
            block13: {
                block12: {
                    void $receiver$iv;
                    Unit unit;
                    KtElement ktElement2;
                    Unit unit2;
                    Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                    PsiElement psiElement = diagnostic.getPsiElement();
                    if (!(psiElement instanceof KtElement)) {
                        psiElement = null;
                    }
                    boolean value$iv = (element2 = (KtElement)psiElement) instanceof KtBreakExpression || element2 instanceof KtContinueExpression;
                    if (_Assertions.ENABLED) {
                        if (!value$iv) {
                            String message$iv$iv = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                        }
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = Unit.INSTANCE;
                    }
                    if (!((ktElement2 = element2) instanceof KtLabeledExpression)) {
                        ktElement2 = null;
                    }
                    KtLabeledExpression ktLabeledExpression = (KtLabeledExpression)ktElement2;
                    value$iv = (ktLabeledExpression != null ? ktLabeledExpression.getLabelName() : null) == null;
                    if (_Assertions.ENABLED) {
                        if (!value$iv) {
                            String message$iv$iv = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = Unit.INSTANCE;
                    }
                    if ((ktElement = element2) == null) break block12;
                    PsiElement message$iv$iv = (PsiElement)ktElement;
                    ktElement = (KtLoopExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtLoopExpression.class, (boolean)true);
                    if (ktElement != null) break block13;
                }
                return null;
            }
            KtElement loop = ktElement;
            KtElement ktElement3 = element2;
            if (ktElement3 == null) {
                Intrinsics.throwNpe();
            }
            return new AddLoopLabelFix((KtLoopExpression)loop, ktElement3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

