/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractFunction.ui;

import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.EditableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Parameter;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.types.KotlinType;

public class KotlinParameterTablePanel
extends JPanel {
    private List<ParameterInfo> parameterInfos;
    private JBTable myTable;
    private MyTableModel myTableModel;

    public KotlinParameterTablePanel() {
        super(new BorderLayout());
    }

    public void init(@Nullable Parameter receiver, @NotNull List<Parameter> parameters2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel", "init"));
        }
        this.parameterInfos = (List)CollectionsKt.mapTo(parameters2, receiver != null ? CollectionsKt.arrayListOf((Object[])new ParameterInfo[]{new ParameterInfo(receiver, true)}) : new ArrayList(), (Function1)new Function1<Parameter, ParameterInfo>(){

            public ParameterInfo invoke(Parameter parameter) {
                return new ParameterInfo(parameter, false);
            }
        });
        this.myTableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)this.myTableModel);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.setCellSelectionEnabled(true);
        TableColumn checkBoxColumn = this.myTable.getColumnModel().getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)checkBoxColumn);
        checkBoxColumn.setHeaderValue("");
        checkBoxColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer(){

            @NotNull
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                Component rendererComponent = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                rendererComponent.setEnabled(KotlinParameterTablePanel.this.isEnabled());
                Component component = rendererComponent;
                if (component == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel$2", "getTableCellRendererComponent"));
                }
                return component;
            }
        });
        this.myTable.getColumnModel().getColumn(1).setHeaderValue("Name");
        TableColumn parameterTypeColumn = this.myTable.getColumnModel().getColumn(2);
        parameterTypeColumn.setHeaderValue("Type");
        parameterTypeColumn.setCellRenderer(new DefaultTableCellRenderer(){
            private final JBComboBoxLabel myLabel = new JBComboBoxLabel();

            @Override
            @NotNull
            public Component getTableCellRendererComponent(@NotNull JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel$3", "getTableCellRendererComponent"));
                }
                this.myLabel.setText(IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType((KotlinType)value2));
                this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                this.myLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                if (isSelected) {
                    this.myLabel.setSelectionIcon();
                } else {
                    this.myLabel.setRegularIcon();
                }
                JBComboBoxLabel jBComboBoxLabel = this.myLabel;
                if (jBComboBoxLabel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel$3", "getTableCellRendererComponent"));
                }
                return jBComboBoxLabel;
            }
        });
        parameterTypeColumn.setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            final JBComboBoxTableCellEditorComponent myEditorComponent = new JBComboBoxTableCellEditorComponent();

            @Nullable
            public Object getCellEditorValue() {
                return this.myEditorComponent.getEditorValue();
            }

            public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
                ParameterInfo info = (ParameterInfo)KotlinParameterTablePanel.this.parameterInfos.get(row);
                this.myEditorComponent.setCell(table, row, column);
                this.myEditorComponent.setOptions(info.getOriginalParameter().getParameterTypeCandidates(false).toArray());
                this.myEditorComponent.setDefaultValue((Object)info.getType());
                this.myEditorComponent.setToString((Function)new Function<Object, String>(){

                    public String fun(Object o) {
                        return IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType((KotlinType)o);
                    }
                });
                return this.myEditorComponent;
            }
        });
        this.myTable.setPreferredScrollableViewportSize(new Dimension(250, this.myTable.getRowHeight() * 5));
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        InputMap inputMap = this.myTable.getInputMap();
        ActionMap actionMap = this.myTable.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel$5", "actionPerformed"));
                }
                if (KotlinParameterTablePanel.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = KotlinParameterTablePanel.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (((ParameterInfo)KotlinParameterTablePanel.this.parameterInfos.get(row)).isEnabled()) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        ((ParameterInfo)KotlinParameterTablePanel.this.parameterInfos.get(row)).setEnabled(valueToBeSet);
                    }
                    KotlinParameterTablePanel.this.myTableModel.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
                    TableUtil.selectRows((JTable)KotlinParameterTablePanel.this.myTable, (int[])rows);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "invoke_impl");
        actionMap.put("invoke_impl", new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel$6", "actionPerformed"));
                }
                TableCellEditor editor = KotlinParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    KotlinParameterTablePanel.this.onEnterAction();
                }
            }
        });
        actionMap.put("doCancel", new AbstractAction(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel$7", "actionPerformed"));
                }
                TableCellEditor editor = KotlinParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    KotlinParameterTablePanel.this.onCancelAction();
                }
            }
        });
        JPanel listPanel = ToolbarDecorator.createDecorator((JTable)this.myTable).disableAddAction().disableRemoveAction().createPanel();
        this.add((Component)listPanel, "Center");
    }

    protected void updateSignature() {
    }

    protected void onEnterAction() {
    }

    protected void onCancelAction() {
    }

    @Nullable
    public ParameterInfo getReceiverInfo() {
        return (ParameterInfo)CollectionsKt.singleOrNull(this.parameterInfos, (Function1)new Function1<ParameterInfo, Boolean>(){

            public Boolean invoke(ParameterInfo info) {
                return info.isEnabled() && info.isReceiver();
            }
        });
    }

    @NotNull
    public List<ParameterInfo> getParameterInfos() {
        List list2 = CollectionsKt.filter(this.parameterInfos, (Function1)new Function1<ParameterInfo, Boolean>(){

            public Boolean invoke(ParameterInfo info) {
                return info.isEnabled() && !info.isReceiver();
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel", "getParameterInfos"));
        }
        return list2;
    }

    @NotNull
    public JBTable getTable() {
        JBTable jBTable = this.myTable;
        if (jBTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel", "getTable"));
        }
        return jBTable;
    }

    private class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        public static final int CHECKMARK_COLUMN = 0;
        public static final int PARAMETER_NAME_COLUMN = 1;
        public static final int PARAMETER_TYPE_COLUMN = 2;

        private MyTableModel() {
        }

        public void addRow() {
            throw new IllegalAccessError("Not implemented");
        }

        public void removeRow(int index2) {
            throw new IllegalAccessError("Not implemented");
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            if (oldIndex < 0 || newIndex < 0) {
                return;
            }
            if (oldIndex >= KotlinParameterTablePanel.this.parameterInfos.size() || newIndex >= KotlinParameterTablePanel.this.parameterInfos.size()) {
                return;
            }
            ParameterInfo old = (ParameterInfo)KotlinParameterTablePanel.this.parameterInfos.get(oldIndex);
            KotlinParameterTablePanel.this.parameterInfos.set(oldIndex, KotlinParameterTablePanel.this.parameterInfos.get(newIndex));
            KotlinParameterTablePanel.this.parameterInfos.set(newIndex, old);
            this.fireTableRowsUpdated(Math.min(oldIndex, newIndex), Math.max(oldIndex, newIndex));
            KotlinParameterTablePanel.this.updateSignature();
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            if (oldIndex < 0 || newIndex < 0) {
                return false;
            }
            return oldIndex < KotlinParameterTablePanel.this.parameterInfos.size() && newIndex < KotlinParameterTablePanel.this.parameterInfos.size();
        }

        @Override
        public int getRowCount() {
            return KotlinParameterTablePanel.this.parameterInfos.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((ParameterInfo)KotlinParameterTablePanel.this.parameterInfos.get(rowIndex)).isEnabled();
                }
                case 1: {
                    return ((ParameterInfo)KotlinParameterTablePanel.this.parameterInfos.get(rowIndex)).getName();
                }
                case 2: {
                    return ((ParameterInfo)KotlinParameterTablePanel.this.parameterInfos.get(rowIndex)).getType();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ParameterInfo info = (ParameterInfo)KotlinParameterTablePanel.this.parameterInfos.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    info.setEnabled((Boolean)aValue);
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    KotlinParameterTablePanel.this.myTable.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                    KotlinParameterTablePanel.this.updateSignature();
                    break;
                }
                case 1: {
                    String name2 = (String)aValue;
                    if (KotlinNameSuggester.INSTANCE.isIdentifier(name2)) {
                        info.setName(name2);
                    }
                    KotlinParameterTablePanel.this.updateSignature();
                    break;
                }
                case 2: {
                    info.setType((KotlinType)aValue);
                    KotlinParameterTablePanel.this.updateSignature();
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ParameterInfo info = (ParameterInfo)KotlinParameterTablePanel.this.parameterInfos.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return KotlinParameterTablePanel.this.isEnabled();
                }
                case 1: {
                    return KotlinParameterTablePanel.this.isEnabled() && info.isEnabled() && !info.isReceiver();
                }
                case 2: {
                    return KotlinParameterTablePanel.this.isEnabled() && info.isEnabled() && info.getOriginalParameter().getParameterTypeCandidates(false).size() > 1;
                }
            }
            return false;
        }

        @NotNull
        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                if (Boolean.class == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel$MyTableModel", "getColumnClass"));
                }
                return Boolean.class;
            }
            Class<?> clazz = super.getColumnClass(columnIndex);
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinParameterTablePanel$MyTableModel", "getColumnClass"));
            }
            return clazz;
        }
    }

    public static class ParameterInfo {
        private final Parameter originalParameter;
        private final boolean receiver;
        private String name;
        private KotlinType type;
        private boolean enabled = true;

        public ParameterInfo(Parameter originalParameter, boolean receiver) {
            this.originalParameter = originalParameter;
            this.receiver = receiver;
            this.name = receiver ? "<receiver>" : originalParameter.getName();
            this.type = originalParameter.getParameterType(false);
        }

        public Parameter getOriginalParameter() {
            return this.originalParameter;
        }

        public boolean isReceiver() {
            return this.receiver;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name2) {
            this.name = name2;
        }

        public KotlinType getType() {
            return this.type;
        }

        public void setType(KotlinType type2) {
            this.type = type2;
        }

        public Parameter toParameter() {
            return this.originalParameter.copy(this.name, this.type);
        }
    }
}

