/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structureView;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.util.PsiIconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinDescriptorIconProvider;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverrideResolver;

class KotlinStructureElementPresentation
implements ColoredItemPresentation,
LocationPresentation {
    private final TextAttributesKey attributesKey;
    private final String elementText;
    private final String locationString;
    private final Icon icon;
    private final boolean isInherited;

    public KotlinStructureElementPresentation(boolean isInherited, @NotNull NavigatablePsiElement navigatablePsiElement, @Nullable DeclarationDescriptor descriptor2) {
        if (navigatablePsiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatablePsiElement", "org/jetbrains/kotlin/idea/structureView/KotlinStructureElementPresentation", "<init>"));
        }
        this.isInherited = isInherited;
        this.attributesKey = KotlinStructureElementPresentation.getElementAttributesKey(isInherited, navigatablePsiElement);
        this.elementText = KotlinStructureElementPresentation.getElementText(navigatablePsiElement, descriptor2);
        this.locationString = KotlinStructureElementPresentation.getElementLocationString(isInherited, descriptor2);
        this.icon = KotlinStructureElementPresentation.getElementIcon(navigatablePsiElement, descriptor2);
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return this.attributesKey;
    }

    @Nullable
    public String getPresentableText() {
        return this.elementText;
    }

    @Nullable
    public String getLocationString() {
        return this.locationString;
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return this.icon;
    }

    public String getLocationPrefix() {
        return this.isInherited ? " " : " (";
    }

    public String getLocationSuffix() {
        return this.isInherited ? "" : ")";
    }

    @Nullable
    private static TextAttributesKey getElementAttributesKey(boolean isInherited, @NotNull NavigatablePsiElement navigatablePsiElement) {
        if (navigatablePsiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatablePsiElement", "org/jetbrains/kotlin/idea/structureView/KotlinStructureElementPresentation", "getElementAttributesKey"));
        }
        if (isInherited) {
            return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
        }
        if (navigatablePsiElement instanceof KtModifierListOwner && KtPsiUtil.isDeprecated((KtModifierListOwner)navigatablePsiElement)) {
            return CodeInsightColors.DEPRECATED_ATTRIBUTES;
        }
        return null;
    }

    @Nullable
    private static Icon getElementIcon(@NotNull NavigatablePsiElement navigatablePsiElement, @Nullable DeclarationDescriptor descriptor2) {
        if (navigatablePsiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatablePsiElement", "org/jetbrains/kotlin/idea/structureView/KotlinStructureElementPresentation", "getElementIcon"));
        }
        if (descriptor2 != null) {
            return KotlinDescriptorIconProvider.getIcon(descriptor2, (PsiElement)navigatablePsiElement, 1);
        }
        return PsiIconUtil.getProvidersIcon((PsiElement)navigatablePsiElement, (int)1);
    }

    @Nullable
    private static String getElementText(@NotNull NavigatablePsiElement navigatablePsiElement, @Nullable DeclarationDescriptor descriptor2) {
        if (navigatablePsiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatablePsiElement", "org/jetbrains/kotlin/idea/structureView/KotlinStructureElementPresentation", "getElementText"));
        }
        if (descriptor2 != null) {
            return DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.render(descriptor2);
        }
        String text2 = navigatablePsiElement.getName();
        if (!StringUtil.isEmpty((String)text2)) {
            return text2;
        }
        if (navigatablePsiElement instanceof KtAnonymousInitializer) {
            return "<class initializer>";
        }
        return null;
    }

    @Nullable
    private static String getElementLocationString(boolean isInherited, @Nullable DeclarationDescriptor descriptor2) {
        if (!isInherited || !(descriptor2 instanceof CallableMemberDescriptor)) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)descriptor2;
        if (callableMemberDescriptor.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            return KotlinStructureElementPresentation.withRightArrow(DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.render(callableMemberDescriptor.getContainingDeclaration()));
        }
        Set<CallableMemberDescriptor> overridingDescriptors = OverrideResolver.filterOutOverridden(DescriptorUtils.getAllOverriddenDeclarations(callableMemberDescriptor));
        CallableMemberDescriptor firstOverriding = (CallableMemberDescriptor)ContainerUtil.getFirstItem(overridingDescriptors);
        if (firstOverriding != null) {
            return KotlinStructureElementPresentation.withRightArrow(DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.render(firstOverriding.getContainingDeclaration()));
        }
        return null;
    }

    private static String withRightArrow(String str) {
        char rightArrow = '\u2192';
        return UIUtil.getLabelFont().canDisplay(rightArrow) ? rightArrow + str : "->" + str;
    }
}

