/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KtJavaMirrorMarker;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaConstructor;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaTypeSubstitutor;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassifierImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassifierTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeParameterImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public class JavaClassImpl
extends JavaClassifierImpl<PsiClass>
implements JavaClass,
JavaAnnotationOwnerImpl,
JavaModifierListOwnerImpl {
    public JavaClassImpl(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "<init>"));
        }
        super(psiClass);
        assert (!(psiClass instanceof PsiTypeParameter)) : "PsiTypeParameter should be wrapped in JavaTypeParameter, not JavaClass: use JavaClassifier.create()";
    }

    @Override
    @NotNull
    public Collection<JavaClass> getInnerClasses() {
        Collection<JavaClass> collection = JavaElementCollectionFromPsiArrayUtil.classes(((PsiClass)this.getPsi()).getInnerClasses());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getInnerClasses"));
        }
        return collection;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        String qualifiedName = ((PsiClass)this.getPsi()).getQualifiedName();
        return qualifiedName == null ? null : new FqName(qualifiedName);
    }

    @Override
    @NotNull
    public Name getName() {
        Name name2 = Name.identifier(((PsiClass)this.getPsi()).getName());
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getName"));
        }
        return name2;
    }

    @Override
    public boolean isInterface() {
        return ((PsiClass)this.getPsi()).isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return ((PsiClass)this.getPsi()).isAnnotationType();
    }

    @Override
    public boolean isEnum() {
        return ((PsiClass)this.getPsi()).isEnum();
    }

    @Override
    @Nullable
    public JavaClass getOuterClass() {
        PsiClass outer = ((PsiClass)this.getPsi()).getContainingClass();
        return outer == null ? null : new JavaClassImpl(outer);
    }

    @Override
    @NotNull
    public List<JavaTypeParameter> getTypeParameters() {
        List<JavaTypeParameter> list2 = JavaElementCollectionFromPsiArrayUtil.typeParameters(((PsiClass)this.getPsi()).getTypeParameters());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getTypeParameters"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        Collection<JavaClassifierType> collection = JavaElementCollectionFromPsiArrayUtil.classifierTypes(((PsiClass)this.getPsi()).getSuperTypes());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getSupertypes"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JavaMethod> getMethods() {
        Collection<JavaMethod> collection = JavaElementCollectionFromPsiArrayUtil.methods(ArraysKt.filter((Object[])((PsiClass)this.getPsi()).getMethods(), (Function1)new Function1<PsiMethod, Boolean>(){

            public Boolean invoke(PsiMethod method) {
                return !method.isConstructor() && method.getReturnType() != null;
            }
        }));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getMethods"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JavaField> getFields() {
        Collection<JavaField> collection = JavaElementCollectionFromPsiArrayUtil.fields(ArraysKt.filter((Object[])((PsiClass)this.getPsi()).getFields(), (Function1)new Function1<PsiField, Boolean>(){

            public Boolean invoke(PsiField field2) {
                String name2 = field2.getName();
                return name2 != null && Name.isValidIdentifier(name2);
            }
        }));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getFields"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JavaConstructor> getConstructors() {
        Collection<JavaConstructor> collection = JavaElementCollectionFromPsiArrayUtil.constructors(ArraysKt.filter((Object[])((PsiClass)this.getPsi()).getConstructors(), (Function1)new Function1<PsiMethod, Boolean>(){

            public Boolean invoke(PsiMethod method) {
                return method.isConstructor();
            }
        }));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getConstructors"));
        }
        return collection;
    }

    @Override
    public boolean isAbstract() {
        return JavaElementUtil.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return JavaElementUtil.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return JavaElementUtil.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = JavaElementUtil.getVisibility(this);
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @NotNull
    public JavaClassifierType getDefaultType() {
        JavaClassifierTypeImpl javaClassifierTypeImpl = new JavaClassifierTypeImpl(JavaPsiFacade.getElementFactory((Project)((PsiClass)this.getPsi()).getProject()).createType((PsiClass)this.getPsi()));
        if (javaClassifierTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getDefaultType"));
        }
        return javaClassifierTypeImpl;
    }

    @Override
    @NotNull
    public JavaClass.OriginKind getOriginKind() {
        PsiClass psiClass = (PsiClass)this.getPsi();
        if (psiClass instanceof KtJavaMirrorMarker) {
            JavaClass.OriginKind originKind = JavaClass.OriginKind.KOTLIN_LIGHT_CLASS;
            if (originKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getOriginKind"));
            }
            return originKind;
        }
        if (psiClass instanceof PsiCompiledElement) {
            JavaClass.OriginKind originKind = JavaClass.OriginKind.COMPILED;
            if (originKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getOriginKind"));
            }
            return originKind;
        }
        JavaClass.OriginKind originKind = JavaClass.OriginKind.SOURCE;
        if (originKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "getOriginKind"));
        }
        return originKind;
    }

    @Override
    @NotNull
    public JavaType createImmediateType(@NotNull JavaTypeSubstitutor substitutor3) {
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "createImmediateType"));
        }
        JavaClassifierTypeImpl javaClassifierTypeImpl = new JavaClassifierTypeImpl(JavaPsiFacade.getElementFactory((Project)((PsiClass)this.getPsi()).getProject()).createType((PsiClass)this.getPsi(), JavaClassImpl.createPsiSubstitutor(substitutor3)));
        if (javaClassifierTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "createImmediateType"));
        }
        return javaClassifierTypeImpl;
    }

    @NotNull
    private static PsiSubstitutor createPsiSubstitutor(@NotNull JavaTypeSubstitutor substitutor3) {
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "createPsiSubstitutor"));
        }
        HashMap substMap = new HashMap();
        for (Map.Entry<JavaTypeParameter, JavaType> entry : substitutor3.getSubstitutionMap().entrySet()) {
            PsiTypeParameter key = (PsiTypeParameter)((JavaTypeParameterImpl)entry.getKey()).getPsi();
            if (entry.getValue() == null) {
                substMap.put(key, null);
                continue;
            }
            substMap.put(key, ((JavaTypeImpl)entry.getValue()).getPsi());
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(substMap);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/structure/impl/JavaClassImpl", "createPsiSubstitutor"));
        }
        return psiSubstitutor;
    }
}

