/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class AnalyzingUtils {
    public static void checkForSyntacticErrors(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/resolve/AnalyzingUtils", "checkForSyntacticErrors"));
        }
        root.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(PsiErrorElement element2) {
                throw new IllegalArgumentException(element2.getErrorDescription() + "; looking at " + element2.getNode().getElementType() + " '" + element2.getText() + DiagnosticUtils.atLocation((PsiElement)element2));
            }
        });
    }

    public static List<PsiErrorElement> getSyntaxErrorRanges(@NotNull PsiElement root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/resolve/AnalyzingUtils", "getSyntaxErrorRanges"));
        }
        final ArrayList<PsiErrorElement> r = new ArrayList<PsiErrorElement>();
        root.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(PsiErrorElement element2) {
                r.add(element2);
            }
        });
        return r;
    }

    public static void throwExceptionOnErrors(BindingContext bindingContext2) {
        AnalyzingUtils.throwExceptionOnErrors(bindingContext2.getDiagnostics());
    }

    public static void throwExceptionOnErrors(Diagnostics diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            DiagnosticSink.THROW_EXCEPTION.report(diagnostic);
        }
    }

    public static String formDebugNameForBindingTrace(@NotNull String debugName2, @Nullable Object resolutionSubjectForMessage) {
        if (debugName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/resolve/AnalyzingUtils", "formDebugNameForBindingTrace"));
        }
        StringBuilder debugInfo = new StringBuilder(debugName2);
        if (resolutionSubjectForMessage instanceof KtElement) {
            KtElement element2 = (KtElement)resolutionSubjectForMessage;
            debugInfo.append(" ").append(DebugTextUtilKt.getDebugText(element2));
            debugInfo.append(" in ").append(element2.getContainingFile().getName());
        } else if (resolutionSubjectForMessage != null) {
            debugInfo.append(" ").append(resolutionSubjectForMessage);
        }
        return debugInfo.toString();
    }

    public static abstract class PsiErrorElementVisitor
    extends KtTreeVisitorVoid {
        public abstract void visitErrorElement(PsiErrorElement var1);
    }
}

