/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.tools.cli.AbstractCli;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.ArtifactScanningListener;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.ScanningResult;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;
import org.sonatype.nexus.index.packer.IndexPacker;
import org.sonatype.nexus.index.packer.IndexPackingRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusIndexerCli
extends AbstractCli {
    public static final char REPO = 'r';
    public static final char INDEX = 'i';
    public static final char NAME = 'n';
    public static final char TYPE = 't';
    public static final char TARGET_DIR = 'd';
    public static final char CREATE_INCREMENTAL_CHUNKS = 'c';
    public static final char CREATE_FILE_CHECKSUMS = 's';
    private static final long MB = 0x100000L;
    private Options options;

    public static void main(String[] args) throws Exception {
        new NexusIndexerCli().execute(args);
    }

    public String getPomPropertiesPath() {
        return "META-INF/maven/org.sonatype.nexus/nexus-indexer/pom.properties";
    }

    public Options buildCliOptions(Options options) {
        this.options = options;
        OptionBuilder.withLongOpt((String)"index");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to the index folder.");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"destination");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Target folder.");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"repository");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to the Maven repository.");
        options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Repository name.");
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.withLongOpt((String)"chunks");
        OptionBuilder.withDescription((String)"Create incremental chunks.");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"checksums");
        OptionBuilder.withDescription((String)"Create checksums for all files (sha1, md5).");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Indexer type (default, min, full or coma separated list of custom types).");
        options.addOption(OptionBuilder.create((char)'t'));
        return options;
    }

    public void displayHelp() {
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("nexus-indexer [options]", "\nOptions:", this.options, "\n");
    }

    public void invokePlexusComponent(CommandLine cli, PlexusContainer plexus) throws Exception {
        if (cli.hasOption('i')) {
            this.index(cli, plexus);
        } else {
            this.displayHelp();
        }
    }

    private void index(CommandLine cli, PlexusContainer plexus) throws ComponentLookupException, IOException, UnsupportedExistingLuceneIndexException {
        String indexDirectoryName = cli.getOptionValue('i');
        File indexFolder = new File(indexDirectoryName);
        String outputDirectoryName = cli.getOptionValue('d', ".");
        File outputFolder = new File(outputDirectoryName);
        File repositoryFolder = new File(cli.getOptionValue('r'));
        String repositoryName = cli.getOptionValue('n', indexFolder.getName());
        List<IndexCreator> indexers = this.getIndexers(cli, plexus);
        boolean createChecksums = cli.hasOption('s');
        boolean createIncrementalChunks = cli.hasOption('c');
        System.err.printf("Repository Folder: %s\n", repositoryFolder.getAbsolutePath());
        System.err.printf("Index Folder:      %s\n", indexFolder.getAbsolutePath());
        System.err.printf("Output Folder:     %s\n", outputFolder.getAbsolutePath());
        System.err.printf("Repository name:   %s\n", repositoryName);
        System.err.printf("Indexers: %s\n", indexers.toString());
        if (createChecksums) {
            System.err.printf("Will create checksum files for all published files (sha1, md5).\n", new Object[0]);
        } else {
            System.err.printf("Will not create checksum files.\n", new Object[0]);
        }
        if (createIncrementalChunks) {
            System.err.printf("Will create incremental chunks for changes, along with baseline file.\n", new Object[0]);
        } else {
            System.err.printf("Will create incremental chunks.\n", new Object[0]);
        }
        NexusIndexer indexer = (NexusIndexer)plexus.lookup(NexusIndexer.class);
        long tstart = System.currentTimeMillis();
        IndexingContext context = indexer.addIndexingContext(repositoryName, repositoryName, repositoryFolder, indexFolder, null, null, indexers);
        IndexPacker packer = (IndexPacker)plexus.lookup(IndexPacker.class);
        boolean debug = cli.hasOption('X');
        IndexerListener listener = new IndexerListener(context, debug);
        indexer.scan(context, listener, true);
        IndexPackingRequest request = new IndexPackingRequest(context, outputFolder);
        request.setCreateChecksumFiles(createChecksums);
        request.setCreateIncrementalChunks(createIncrementalChunks);
        this.packIndex(packer, request, debug);
        long t = System.currentTimeMillis() - tstart;
        long s = t / 1000L;
        if (t > 60000L) {
            long m = t / 1000L / 60L;
            System.err.printf("Total time:   %d min %d sec\n", m, s - m * 60L);
        } else {
            System.err.printf("Total time:   %d sec\n", s);
        }
        Runtime r = Runtime.getRuntime();
        System.err.printf("Final memory: %dM/%dM\n", (r.totalMemory() - r.freeMemory()) / 0x100000L, r.totalMemory() / 0x100000L);
    }

    private List<IndexCreator> getIndexers(CommandLine cli, PlexusContainer plexus) throws ComponentLookupException {
        String type = "default";
        if (cli.hasOption('t')) {
            type = cli.getOptionValue('t');
        }
        ArrayList<IndexCreator> indexers = new ArrayList<IndexCreator>();
        if ("default".equals(type)) {
            indexers.add((IndexCreator)plexus.lookup(IndexCreator.class, "min"));
            indexers.add((IndexCreator)plexus.lookup(IndexCreator.class, "jarContent"));
        } else if ("full".equals(type)) {
            for (IndexCreator component : plexus.lookupList(IndexCreator.class)) {
                indexers.add(component);
            }
        } else {
            for (String hint : type.split(",")) {
                indexers.add((IndexCreator)plexus.lookup(IndexCreator.class, hint));
            }
        }
        return indexers;
    }

    private void packIndex(IndexPacker packer, IndexPackingRequest request, boolean debug) {
        block2: {
            try {
                packer.packIndex(request);
            }
            catch (IOException e) {
                System.err.printf("Cannot zip index; \n", e.getMessage());
                if (!debug) break block2;
                e.printStackTrace();
            }
        }
    }

    private static final class IndexerListener
    implements ArtifactScanningListener {
        private final IndexingContext context;
        private final boolean debug;
        private long ts = System.currentTimeMillis();
        private int count;

        IndexerListener(IndexingContext context, boolean debug) {
            this.context = context;
            this.debug = debug;
        }

        public void scanningStarted(IndexingContext context) {
            System.err.println("Scanning started");
        }

        public void artifactDiscovered(ArtifactContext ac) {
            ++this.count;
            long t = System.currentTimeMillis();
            ArtifactInfo ai = ac.getArtifactInfo();
            if (this.debug && "maven-plugin".equals(ai.packaging)) {
                System.err.printf("Plugin: %s:%s:%s - %s %s\n", ai.groupId, ai.artifactId, ai.version, ai.prefix, "" + ai.goals);
            }
            if (this.debug || t - this.ts > 2000L) {
                System.err.printf("  %6d %s\n", this.count, this.formatFile(ac.getPom()));
                this.ts = t;
            }
        }

        public void artifactError(ArtifactContext ac, Exception e) {
            System.err.printf("! %6d %s - %s\n", this.count, this.formatFile(ac.getPom()), e.getMessage());
            System.err.printf("         %s\n", this.formatFile(ac.getArtifact()));
            if (this.debug) {
                e.printStackTrace();
            }
            this.ts = System.currentTimeMillis();
        }

        private String formatFile(File file) {
            return file.getAbsolutePath().substring(this.context.getRepository().getAbsolutePath().length() + 1);
        }

        public void scanningFinished(IndexingContext context, ScanningResult result) {
            if (result.hasExceptions()) {
                System.err.printf("Scanning errors:   %s\n", result.getExceptions().size());
            }
            System.err.printf("Artifacts added:   %s\n", result.getTotalFiles());
            System.err.printf("Artifacts deleted: %s\n", result.getDeletedFiles());
        }
    }
}

