/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.windows.NamedPipe;
import java.io.IOException;
import java.io.InputStream;

public class WinPTYInputStream
extends InputStream {
    private final NamedPipe myNamedPipe;
    private boolean myClosed;

    public WinPTYInputStream(NamedPipe namedPipe) {
        this.myNamedPipe = namedPipe;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (1 != this.read(b, 0, 1)) {
            return -1;
        }
        return b[0];
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.myClosed) {
            return 0;
        }
        return this.myNamedPipe.read(buf, off, len);
    }

    public void close() throws IOException {
        this.myClosed = true;
        this.myNamedPipe.markClosed();
    }

    public int available() throws IOException {
        return this.myNamedPipe.available();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

