/*
 * Decompiled with CFR 0.152.
 */
package com.android.jarutils;

import com.android.jarutils.DebugKeyProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.ArrayList;

public final class KeystoreHelper {
    public static boolean createNewStore(String osKeyStorePath, String storeType, String storePassword, String alias, String keyPassword, String description, int validityYears, DebugKeyProvider.IKeyGenOutput output) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, IOException, DebugKeyProvider.KeytoolException {
        String os = System.getProperty("os.name");
        String keytoolCommand = os.startsWith("Windows") ? "keytool.exe" : "keytool";
        String javaHome = System.getProperty("java.home");
        if (javaHome != null && javaHome.length() > 0) {
            keytoolCommand = javaHome + File.separator + "bin" + File.separator + keytoolCommand;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(keytoolCommand);
        commandList.add("-genkey");
        commandList.add("-alias");
        commandList.add(alias);
        commandList.add("-keyalg");
        commandList.add("RSA");
        commandList.add("-dname");
        commandList.add(description);
        commandList.add("-validity");
        commandList.add(Integer.toString(validityYears * 365));
        commandList.add("-keypass");
        commandList.add(keyPassword);
        commandList.add("-keystore");
        commandList.add(osKeyStorePath);
        commandList.add("-storepass");
        commandList.add(storePassword);
        if (storeType != null) {
            commandList.add("-storetype");
            commandList.add(storeType);
        }
        String[] commandArray = commandList.toArray(new String[commandList.size()]);
        int result = 0;
        try {
            result = KeystoreHelper.grabProcessOutput(Runtime.getRuntime().exec(commandArray), output);
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder();
            boolean firstArg = true;
            for (String arg : commandArray) {
                boolean hasSpace;
                boolean bl = hasSpace = arg.indexOf(32) != -1;
                if (firstArg) {
                    firstArg = false;
                } else {
                    builder.append(' ');
                }
                if (hasSpace) {
                    builder.append('\"');
                }
                builder.append(arg);
                if (!hasSpace) continue;
                builder.append('\"');
            }
            throw new DebugKeyProvider.KeytoolException("Failed to create key: " + e.getMessage(), javaHome, builder.toString());
        }
        return result == 0;
    }

    private static int grabProcessOutput(final Process process, final DebugKeyProvider.IKeyGenOutput output) {
        Thread t1 = new Thread(""){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getErrorStream());
                BufferedReader errReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = errReader.readLine()) != null) {
                        if (output != null) {
                            output.err(line);
                            continue;
                        }
                        System.err.println(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Thread t2 = new Thread(""){

            public void run() {
                InputStreamReader is = new InputStreamReader(process.getInputStream());
                BufferedReader outReader = new BufferedReader(is);
                try {
                    String line;
                    while ((line = outReader.readLine()) != null) {
                        if (output != null) {
                            output.out(line);
                            continue;
                        }
                        System.out.println(line);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t1.start();
        t2.start();
        try {
            t1.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            return 0;
        }
    }
}

