/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import com.google.common.base.Objects;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.serialize.ObjectReader;
import org.gradle.internal.serialize.ObjectWriter;
import org.gradle.messaging.remote.internal.MessageIOException;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.RemoteConnection;
import org.gradle.messaging.remote.internal.inet.SocketInetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketConnection<T>
implements RemoteConnection<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketConnection.class);
    private final SocketChannel socket;
    private final SocketInetAddress localAddress;
    private final SocketInetAddress remoteAddress;
    private final ObjectWriter<T> objectWriter;
    private final ObjectReader<T> objectReader;
    private final InputStream instr;
    private final OutputStream outstr;

    public SocketConnection(SocketChannel socket, MessageSerializer<T> serializer) {
        this.socket = socket;
        try {
            socket.configureBlocking(false);
            this.outstr = new SocketOutputStream(socket);
            this.instr = new SocketInputStream(socket);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        InetSocketAddress localSocketAddress = (InetSocketAddress)socket.socket().getLocalSocketAddress();
        this.localAddress = new SocketInetAddress(localSocketAddress.getAddress(), localSocketAddress.getPort());
        InetSocketAddress remoteSocketAddress = (InetSocketAddress)socket.socket().getRemoteSocketAddress();
        this.remoteAddress = new SocketInetAddress(remoteSocketAddress.getAddress(), remoteSocketAddress.getPort());
        this.objectReader = serializer.newReader(this.instr, this.localAddress, this.remoteAddress);
        this.objectWriter = serializer.newWriter(this.outstr);
    }

    public String toString() {
        return String.format("socket connection from %s to %s", this.localAddress, this.remoteAddress);
    }

    @Override
    public T receive() throws MessageIOException {
        try {
            return this.objectReader.read();
        }
        catch (EOFException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Discarding EOFException: {}", (Object)e.toString());
            }
            return null;
        }
        catch (Exception e) {
            throw new MessageIOException(String.format("Could not read message from '%s'.", this.remoteAddress), e);
        }
    }

    private static boolean isEndOfStream(Exception e) {
        if (e instanceof EOFException) {
            return true;
        }
        if (e instanceof IOException) {
            if (Objects.equal((Object)e.getMessage(), (Object)"An existing connection was forcibly closed by the remote host")) {
                return true;
            }
            if (Objects.equal((Object)e.getMessage(), (Object)"An established connection was aborted by the software in your host machine")) {
                return true;
            }
            if (Objects.equal((Object)e.getMessage(), (Object)"Connection reset by peer")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void dispatch(T message) throws MessageIOException {
        try {
            this.objectWriter.write(message);
            this.outstr.flush();
        }
        catch (Exception e) {
            throw new MessageIOException(String.format("Could not write message %s to '%s'.", message, this.remoteAddress), e);
        }
    }

    public void requestStop() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.instr}).stop();
    }

    public void stop() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.instr, this.outstr, this.socket}).stop();
    }

    private static class SocketOutputStream
    extends OutputStream {
        private final Selector selector;
        private final SocketChannel socket;
        private final ByteBuffer buffer;
        private final byte[] writeBuffer = new byte[1];

        public SocketOutputStream(SocketChannel socket) throws IOException {
            this.socket = socket;
            this.selector = Selector.open();
            socket.register(this.selector, 4);
            this.buffer = ByteBuffer.allocateDirect(4096);
        }

        public void write(int b) throws IOException {
            this.writeBuffer[0] = (byte)b;
            this.write(this.writeBuffer);
        }

        public void write(byte[] src, int offset, int max) throws IOException {
            int remaining = max;
            int currentPos = offset;
            while (remaining > 0) {
                int count = Math.min(remaining, this.buffer.remaining());
                if (count > 0) {
                    this.buffer.put(src, currentPos, count);
                    remaining -= count;
                    currentPos += count;
                }
                if (this.buffer.remaining() != 0) continue;
                this.flush();
            }
        }

        public void flush() throws IOException {
            this.buffer.flip();
            while (this.buffer.remaining() > 0) {
                this.selector.select();
                if (!this.selector.isOpen()) {
                    throw new EOFException();
                }
                this.socket.write(this.buffer);
            }
            this.buffer.clear();
        }

        public void close() throws IOException {
            this.selector.close();
        }
    }

    private static class SocketInputStream
    extends InputStream {
        private final Selector selector;
        private final ByteBuffer buffer;
        private final SocketChannel socket;
        private final byte[] readBuffer = new byte[1];

        public SocketInputStream(SocketChannel socket) throws IOException {
            this.socket = socket;
            this.selector = Selector.open();
            socket.register(this.selector, 1);
            this.buffer = ByteBuffer.allocateDirect(4096);
            this.buffer.limit(0);
        }

        public int read() throws IOException {
            int nread = this.read(this.readBuffer, 0, 1);
            if (nread <= 0) {
                return nread;
            }
            return this.readBuffer[0];
        }

        public int read(byte[] dest, int offset, int max) throws IOException {
            if (max == 0) {
                return 0;
            }
            if (this.buffer.remaining() == 0) {
                int nread;
                try {
                    this.selector.select();
                }
                catch (ClosedSelectorException e) {
                    return -1;
                }
                if (!this.selector.isOpen()) {
                    return -1;
                }
                this.buffer.clear();
                try {
                    nread = this.socket.read(this.buffer);
                }
                catch (IOException e) {
                    if (SocketConnection.isEndOfStream(e)) {
                        this.buffer.position(0);
                        this.buffer.limit(0);
                        return -1;
                    }
                    throw e;
                }
                this.buffer.flip();
                if (nread < 0) {
                    return -1;
                }
            }
            int count = Math.min(this.buffer.remaining(), max);
            this.buffer.get(dest, offset, count);
            return count;
        }

        public void close() throws IOException {
            this.selector.close();
        }
    }
}

