/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.androidTarget;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Map;

public class MissingTarget
implements IAndroidTarget {
    private final String mVendor;
    private final AndroidVersion mVersion;
    private final List<ISystemImage> mSystemImages = Lists.newArrayList();
    private final String mName;

    public MissingTarget(String vendor, String name, AndroidVersion version) {
        this.mVendor = vendor;
        this.mVersion = version;
        this.mName = name;
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public String getVendor() {
        return this.mVendor;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public String getClasspathName() {
        return null;
    }

    @Override
    public String getShortClasspathName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    @Override
    public String getVersionName() {
        return SdkVersionInfo.getAndroidName(this.getVersion().getApiLevel());
    }

    @Override
    public int getRevision() {
        return 0;
    }

    @Override
    public boolean isPlatform() {
        return this.mVendor == null;
    }

    @Override
    public IAndroidTarget getParent() {
        return null;
    }

    @Override
    public String getPath(int pathId) {
        return null;
    }

    @Override
    public File getFile(int pathId) {
        return null;
    }

    @Override
    public BuildToolInfo getBuildToolInfo() {
        return null;
    }

    @Override
    public List<String> getBootClasspath() {
        return ImmutableList.of();
    }

    @Override
    public List<IAndroidTarget.OptionalLibrary> getOptionalLibraries() {
        return ImmutableList.of();
    }

    @Override
    public List<IAndroidTarget.OptionalLibrary> getAdditionalLibraries() {
        return ImmutableList.of();
    }

    @Override
    public boolean hasRenderingLibrary() {
        return false;
    }

    @Override
    public File[] getSkins() {
        return new File[0];
    }

    @Override
    public File getDefaultSkin() {
        return null;
    }

    @Override
    public String[] getPlatformLibraries() {
        return new String[0];
    }

    @Override
    public String getProperty(String name) {
        return null;
    }

    @Override
    public Integer getProperty(String name, Integer defaultValue) {
        return null;
    }

    @Override
    public Boolean getProperty(String name, Boolean defaultValue) {
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        return null;
    }

    @Override
    public int getUsbVendorId() {
        return 0;
    }

    @Override
    public ISystemImage[] getSystemImages() {
        return this.mSystemImages.toArray(new ISystemImage[this.mSystemImages.size()]);
    }

    public void addSystemImage(ISystemImage image) {
        this.mSystemImages.add(image);
    }

    @Override
    public ISystemImage getSystemImage(IdDisplay tag, String abiType) {
        for (ISystemImage image : this.mSystemImages) {
            if (!tag.equals(image.getTag()) || !abiType.equals(image.getAbiType())) continue;
            return image;
        }
        return null;
    }

    @Override
    public boolean canRunOn(IAndroidTarget target) {
        return false;
    }

    @Override
    public String hashString() {
        return AndroidTargetHash.getTargetHashString(this);
    }

    @Override
    public int compareTo(IAndroidTarget o) {
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MissingTarget)) {
            return false;
        }
        MissingTarget other = (MissingTarget)obj;
        return Objects.equal((Object)this.mVendor, (Object)other.mVendor) && Objects.equal((Object)this.mVersion, (Object)other.mVersion);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mVendor, this.mVersion});
    }
}

