/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.build;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.internal.build.KeystoreHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

@Deprecated
public class DebugKeyProvider {
    private static final String PASSWORD_STRING = "android";
    private static final char[] PASSWORD_CHAR = "android".toCharArray();
    private static final String DEBUG_ALIAS = "AndroidDebugKey";
    private static final String CERTIFICATE_DESC = "CN=Android Debug,O=Android,C=US";
    private KeyStore.PrivateKeyEntry mEntry;

    public DebugKeyProvider(String osKeyStorePath, String storeType, IKeyGenOutput output) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, IOException, KeytoolException, AndroidLocation.AndroidLocationException {
        if (osKeyStorePath == null) {
            osKeyStorePath = DebugKeyProvider.getDefaultKeyStoreOsPath();
        }
        if (!this.loadKeyEntry(osKeyStorePath, storeType)) {
            this.createNewStore(osKeyStorePath, storeType, output);
        }
    }

    public static String getDefaultKeyStoreOsPath() throws KeytoolException, AndroidLocation.AndroidLocationException {
        String folder = AndroidLocation.getFolder();
        if (folder == null) {
            throw new KeytoolException("Failed to get HOME directory!\n");
        }
        String osKeyStorePath = folder + "debug.keystore";
        return osKeyStorePath;
    }

    public PrivateKey getDebugKey() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, UnrecoverableEntryException {
        if (this.mEntry != null) {
            return this.mEntry.getPrivateKey();
        }
        return null;
    }

    public Certificate getCertificate() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, UnrecoverableEntryException {
        if (this.mEntry != null) {
            return this.mEntry.getCertificate();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadKeyEntry(String osKeyStorePath, String storeType) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        FileInputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType != null ? storeType : KeyStore.getDefaultType());
            fis = new FileInputStream(osKeyStorePath);
            keyStore.load(fis, PASSWORD_CHAR);
            this.mEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(DEBUG_ALIAS, new KeyStore.PasswordProtection(PASSWORD_CHAR));
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private void createNewStore(String osKeyStorePath, String storeType, IKeyGenOutput output) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, IOException, KeytoolException {
        if (KeystoreHelper.createNewStore(osKeyStorePath, storeType, PASSWORD_STRING, DEBUG_ALIAS, PASSWORD_STRING, CERTIFICATE_DESC, 30, output)) {
            this.loadKeyEntry(osKeyStorePath, storeType);
        }
    }

    public static class KeytoolException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String mJavaHome = null;
        private String mCommandLine = null;

        KeytoolException(String message) {
            super(message);
        }

        KeytoolException(String message, String javaHome, String commandLine) {
            super(message);
            this.mJavaHome = javaHome;
            this.mCommandLine = commandLine;
        }

        public String getJavaHome() {
            return this.mJavaHome;
        }

        public String getCommandLine() {
            return this.mCommandLine;
        }
    }

    public static interface IKeyGenOutput {
        public void out(String var1);

        public void err(String var1);
    }
}

