/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NotNull;

@State(name="AnalysisUIOptions", storages={@Storage(value="$WORKSPACE_FILE$")})
public class AnalysisUIOptions
implements PersistentStateComponent<AnalysisUIOptions> {
    public boolean AUTOSCROLL_TO_SOURCE = false;
    public float SPLITTER_PROPORTION = 0.5f;
    public boolean GROUP_BY_SEVERITY = false;
    public boolean FILTER_RESOLVED_ITEMS = true;
    public boolean ANALYZE_TEST_SOURCES = true;
    public boolean SHOW_DIFF_WITH_PREVIOUS_RUN = false;
    public int SCOPE_TYPE = 1;
    public String CUSTOM_SCOPE_NAME = "";
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

        protected boolean isAutoScrollMode() {
            return AnalysisUIOptions.this.AUTOSCROLL_TO_SOURCE;
        }

        protected void setAutoScrollMode(boolean state) {
            AnalysisUIOptions.this.AUTOSCROLL_TO_SOURCE = state;
        }
    };
    public boolean SHOW_ONLY_DIFF = false;
    public boolean SHOW_STRUCTURE = false;
    public boolean ANALYSIS_IN_BACKGROUND = false;

    public static AnalysisUIOptions getInstance(Project project2) {
        return (AnalysisUIOptions)ServiceManager.getService((Project)project2, AnalysisUIOptions.class);
    }

    @NotNull
    public AnalysisUIOptions copy() {
        AnalysisUIOptions result = new AnalysisUIOptions();
        XmlSerializerUtil.copyBean((Object)this, (Object)result);
        AnalysisUIOptions analysisUIOptions = result;
        if (analysisUIOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisUIOptions", "copy"));
        }
        return analysisUIOptions;
    }

    public void save(AnalysisUIOptions options) {
        XmlSerializerUtil.copyBean((Object)options, (Object)this);
    }

    public AutoScrollToSourceHandler getAutoScrollToSourceHandler() {
        return this.myAutoScrollToSourceHandler;
    }

    public AnAction createGroupBySeverityAction(final InspectionResultsView view) {
        return new ToggleAction(InspectionsBundle.message((String)"inspection.action.group.by.severity", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.group.by.severity.description", (Object[])new Object[0]), AllIcons.Nodes.SortBySeverity){

            public boolean isSelected(AnActionEvent e) {
                return AnalysisUIOptions.this.GROUP_BY_SEVERITY;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                AnalysisUIOptions.this.GROUP_BY_SEVERITY = state;
                view.update();
            }
        };
    }

    public AnAction createFilterResolvedItemsAction(final InspectionResultsView view) {
        return new ToggleAction(InspectionsBundle.message((String)"inspection.filter.resolved.action.text", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.filter.resolved.action.text", (Object[])new Object[0]), AllIcons.General.Filter){

            public boolean isSelected(AnActionEvent e) {
                return AnalysisUIOptions.this.FILTER_RESOLVED_ITEMS;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                AnalysisUIOptions.this.FILTER_RESOLVED_ITEMS = state;
                view.update();
            }
        };
    }

    public AnAction createShowOutdatedProblemsAction(final InspectionResultsView view) {
        return new ToggleAction(InspectionsBundle.message((String)"inspection.filter.show.diff.action.text", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.filter.show.diff.action.text", (Object[])new Object[0]), AllIcons.Actions.Diff){

            public boolean isSelected(AnActionEvent e) {
                return AnalysisUIOptions.this.SHOW_DIFF_WITH_PREVIOUS_RUN;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                AnalysisUIOptions.this.SHOW_DIFF_WITH_PREVIOUS_RUN = state;
                if (!AnalysisUIOptions.this.SHOW_DIFF_WITH_PREVIOUS_RUN) {
                    AnalysisUIOptions.this.SHOW_ONLY_DIFF = false;
                }
                view.update();
            }
        };
    }

    public AnAction createGroupByDirectoryAction(final InspectionResultsView view) {
        return new ToggleAction("Group by directory", "Group by directory", AllIcons.Actions.GroupByPackage){

            public boolean isSelected(AnActionEvent e) {
                return AnalysisUIOptions.this.SHOW_STRUCTURE;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                AnalysisUIOptions.this.SHOW_STRUCTURE = state;
                view.update();
            }
        };
    }

    public AnAction createShowDiffOnlyAction(final InspectionResultsView view) {
        return new ToggleAction(InspectionsBundle.message((String)"inspection.filter.show.diff.only.action.text", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.filter.show.diff.only.action.text", (Object[])new Object[0]), AllIcons.Actions.ShowChangesOnly){

            public boolean isSelected(AnActionEvent e) {
                return AnalysisUIOptions.this.SHOW_ONLY_DIFF;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                AnalysisUIOptions.this.SHOW_ONLY_DIFF = state;
                view.update();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(AnalysisUIOptions.this.SHOW_DIFF_WITH_PREVIOUS_RUN);
            }
        };
    }

    public AnalysisUIOptions getState() {
        return this;
    }

    public void loadState(AnalysisUIOptions state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }
}

