/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesControl;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRuleManager {
    private static final Set<ArrangementSettingsToken> MUTEXES = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION});
    private static final Set<ArrangementSettingsToken> TOKENS = ContainerUtilRt.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION, StdArrangementTokens.Regexp.TEXT});
    private Commenter myCommenter;
    private ArrangementSectionRulesControl myControl;
    private ArrangementMatchingRuleEditor myEditor;

    @Nullable
    public static ArrangementSectionRuleManager getInstance(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementSectionRulesControl control) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "getInstance"));
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsManager", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "getInstance"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "getInstance"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "getInstance"));
        }
        if (settingsManager.isSectionRulesSupported()) {
            return new ArrangementSectionRuleManager(language, settingsManager, colorsProvider, control);
        }
        return null;
    }

    private ArrangementSectionRuleManager(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementSectionRulesControl control) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "<init>"));
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsManager", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "<init>"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "<init>"));
        }
        this.myCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        this.myControl = control;
        ArrayList tokens = ContainerUtil.newArrayList();
        tokens.add(new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, (Collection)ContainerUtil.newArrayList((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION})));
        tokens.add(new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.TEXT));
        this.myEditor = new ArrangementMatchingRuleEditor(settingsManager, tokens, colorsProvider, control);
    }

    public ArrangementMatchingRuleEditor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public static Set<ArrangementSettingsToken> getSectionMutexes() {
        Set<ArrangementSettingsToken> set = MUTEXES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "getSectionMutexes"));
        }
        return set;
    }

    public static boolean isEnabled(@NotNull ArrangementSettingsToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "isEnabled"));
        }
        return TOKENS.contains(token);
    }

    public void showEditor(int rowToEdit) {
        this.myControl.showEditor(this.myEditor, rowToEdit);
    }

    public boolean isSectionRule(@Nullable Object element) {
        return element instanceof StdArrangementMatchRule && this.getSectionRuleData((StdArrangementMatchRule)element) != null;
    }

    @Nullable
    public ArrangementSectionRuleData getSectionRuleData(@NotNull StdArrangementMatchRule element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "getSectionRuleData"));
        }
        ArrangementMatchCondition condition = element.getMatcher().getCondition();
        return this.getSectionRuleData(condition);
    }

    @Nullable
    public ArrangementSectionRuleData getSectionRuleData(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "getSectionRuleData"));
        }
        final Ref isStart = new Ref();
        final Ref text = new Ref();
        condition.invite(new ArrangementMatchConditionVisitor(){

            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager$1", "visit"));
                }
                ArrangementSettingsToken type = condition.getType();
                if (type.equals((Object)StdArrangementTokens.Section.START_SECTION)) {
                    isStart.set((Object)true);
                } else if (type.equals((Object)StdArrangementTokens.Section.END_SECTION)) {
                    isStart.set((Object)false);
                } else if (type.equals((Object)StdArrangementTokens.Regexp.TEXT)) {
                    text.set((Object)condition.getValue().toString());
                }
            }

            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager$1", "visit"));
                }
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite((ArrangementMatchConditionVisitor)this);
                    if (text.isNull() || isStart.isNull()) continue;
                    return;
                }
            }
        });
        if (isStart.isNull()) {
            return null;
        }
        return new ArrangementSectionRuleData(this.processSectionText(StringUtil.notNullize((String)((String)text.get()))), (Boolean)isStart.get());
    }

    @NotNull
    public StdArrangementMatchRule createDefaultSectionRule() {
        ArrangementAtomMatchCondition type = new ArrangementAtomMatchCondition(StdArrangementTokens.Section.START_SECTION);
        ArrangementAtomMatchCondition text = new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.TEXT, (Object)this.createDefaultSectionText());
        ArrangementMatchCondition condition = ArrangementUtil.combine((ArrangementMatchCondition[])new ArrangementMatchCondition[]{type, text});
        StdArrangementMatchRule stdArrangementMatchRule = new StdArrangementMatchRule(new StdArrangementEntryMatcher(condition));
        if (stdArrangementMatchRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "createDefaultSectionRule"));
        }
        return stdArrangementMatchRule;
    }

    @NotNull
    private String processSectionText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "processSectionText"));
        }
        String lineCommentPrefix = this.myCommenter.getLineCommentPrefix();
        if (lineCommentPrefix != null && text.startsWith(lineCommentPrefix)) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "processSectionText"));
            }
            return string;
        }
        String prefix = this.myCommenter.getBlockCommentPrefix();
        String suffix = this.myCommenter.getBlockCommentSuffix();
        if (prefix != null && suffix != null && text.length() >= prefix.length() + suffix.length() && text.startsWith(prefix) && text.endsWith(suffix)) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "processSectionText"));
            }
            return string;
        }
        String string = lineCommentPrefix != null ? ArrangementSectionRuleManager.wrapIntoLineComment(lineCommentPrefix, text) : (prefix != null && suffix != null ? ArrangementSectionRuleManager.wrapIntoBlockComment(prefix, suffix, text) : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "processSectionText"));
        }
        return string;
    }

    @NotNull
    private String createDefaultSectionText() {
        if (this.myCommenter != null) {
            String lineCommentPrefix = this.myCommenter.getLineCommentPrefix();
            if (StringUtil.isNotEmpty((String)lineCommentPrefix)) {
                String string = ArrangementSectionRuleManager.wrapIntoLineComment(lineCommentPrefix, "");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "createDefaultSectionText"));
                }
                return string;
            }
            String prefix = this.myCommenter.getBlockCommentPrefix();
            String suffix = this.myCommenter.getBlockCommentSuffix();
            if (StringUtil.isNotEmpty((String)prefix) && StringUtil.isNotEmpty((String)suffix)) {
                String string = ArrangementSectionRuleManager.wrapIntoBlockComment(prefix, suffix, " ");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "createDefaultSectionText"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "createDefaultSectionText"));
        }
        return "";
    }

    private static String wrapIntoBlockComment(@NotNull String prefix, @NotNull String suffix, @NotNull String text) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "wrapIntoBlockComment"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "wrapIntoBlockComment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "wrapIntoBlockComment"));
        }
        return prefix + text + suffix;
    }

    private static String wrapIntoLineComment(@NotNull String lineCommentPrefix, @NotNull String text) {
        if (lineCommentPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineCommentPrefix", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "wrapIntoLineComment"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager", "wrapIntoLineComment"));
        }
        return lineCommentPrefix + text;
    }

    public static class ArrangementSectionRuleData {
        private boolean myIsSectionStart;
        private String myText;

        private ArrangementSectionRuleData(@NotNull String text, boolean isStart) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager$ArrangementSectionRuleData", "<init>"));
            }
            this.myText = text;
            this.myIsSectionStart = isStart;
        }

        public boolean isSectionStart() {
            return this.myIsSectionStart;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager$ArrangementSectionRuleData", "getText"));
            }
            return string;
        }
    }
}

