/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CollectionsUtilityMethodsProvider {
    private final PsiElement myElement;
    private final PsiType myExpectedType;
    private final PsiType myDefaultType;
    @NotNull
    private final Consumer<LookupElement> myResult;

    CollectionsUtilityMethodsProvider(PsiElement position, PsiType expectedType, PsiType defaultType, @NotNull Consumer<LookupElement> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/CollectionsUtilityMethodsProvider", "<init>"));
        }
        this.myResult = result;
        this.myElement = position;
        this.myExpectedType = expectedType;
        this.myDefaultType = defaultType;
    }

    public void addCompletions(boolean showAll) {
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifierExpression() != null) {
            return;
        }
        PsiClass collectionsClass = JavaPsiFacade.getInstance((Project)this.myElement.getProject()).findClass("java.util.Collections", this.myElement.getResolveScope());
        if (collectionsClass == null) {
            return;
        }
        PsiElement pparent = parent.getParent();
        if (showAll || pparent instanceof PsiReturnStatement || pparent instanceof PsiConditionalExpression && pparent.getParent() instanceof PsiReturnStatement) {
            this.addCollectionMethod("java.util.List", "emptyList", collectionsClass);
            this.addCollectionMethod("java.util.Set", "emptySet", collectionsClass);
            this.addCollectionMethod("java.util.Map", "emptyMap", collectionsClass);
        }
        if (showAll) {
            this.addCollectionMethod("java.util.List", "singletonList", collectionsClass);
            this.addCollectionMethod("java.util.Set", "singleton", collectionsClass);
            this.addCollectionMethod("java.util.Map", "singletonMap", collectionsClass);
            this.addCollectionMethod("java.util.Collection", "unmodifiableCollection", collectionsClass);
            this.addCollectionMethod("java.util.List", "unmodifiableList", collectionsClass);
            this.addCollectionMethod("java.util.Set", "unmodifiableSet", collectionsClass);
            this.addCollectionMethod("java.util.Map", "unmodifiableMap", collectionsClass);
            this.addCollectionMethod("java.util.SortedSet", "unmodifiableSortedSet", collectionsClass);
            this.addCollectionMethod("java.util.SortedMap", "unmodifiableSortedMap", collectionsClass);
        }
    }

    private void addCollectionMethod(String baseClassName, @NonNls String method, @NotNull PsiClass collectionsClass) {
        if (collectionsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectionsClass", "com/intellij/codeInsight/completion/CollectionsUtilityMethodsProvider", "addCollectionMethod"));
        }
        if (CollectionsUtilityMethodsProvider.isClassType(this.myExpectedType, baseClassName) || CollectionsUtilityMethodsProvider.isClassType(this.myExpectedType, "java.util.Collection")) {
            this.addMethodItem(this.myExpectedType, method, collectionsClass);
        } else if (CollectionsUtilityMethodsProvider.isClassType(this.myDefaultType, baseClassName) || CollectionsUtilityMethodsProvider.isClassType(this.myDefaultType, "java.util.Collection")) {
            this.addMethodItem(this.myDefaultType, method, collectionsClass);
        }
    }

    private void addMethodItem(PsiType expectedType, String methodName, PsiClass containingClass) {
        PsiMethod[] methods = containingClass.findMethodsByName(methodName, false);
        if (methods.length == 0) {
            return;
        }
        PsiMethod method = methods[0];
        JavaMethodCallElement item = new JavaMethodCallElement(method, false, false);
        item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        item.setInferenceSubstitutor(SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, expectedType), this.myElement);
        this.myResult.consume((Object)item);
    }

    private static boolean isClassType(PsiType type, String className) {
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && className.equals(psiClass.getQualifiedName());
        }
        return false;
    }
}

