/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.TemplateGenerationInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class JavaGenerateMemberCompletionContributor {
    static final Key<Boolean> GENERATE_ELEMENT = Key.create((String)"GENERATE_ELEMENT");

    public static void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        if (parameters.getCompletionType() != CompletionType.BASIC && parameters.getCompletionType() != CompletionType.SMART) {
            return;
        }
        PsiElement position = parameters.getPosition();
        if (((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiIdentifier.class).withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiTypeElement.class, PsiClass.class})).andNot(JavaKeywordCompletion.AFTER_DOT)).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().inside(PsiModifierList.class)))).accepts((Object)position)) {
            JavaGenerateMemberCompletionContributor.suggestGeneratedMethods(result, position);
        } else if (((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiIdentifier.class).withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class, PsiModifierList.class, PsiClass.class})).accepts((Object)position)) {
            PsiAnnotation annotation = (PsiAnnotation)ObjectUtils.assertNotNull((Object)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class));
            int annoStart = annotation.getTextRange().getStartOffset();
            JavaGenerateMemberCompletionContributor.suggestGeneratedMethods(result.withPrefixMatcher(annotation.getText().substring(0, parameters.getOffset() - annoStart)), position);
        }
    }

    private static void suggestGeneratedMethods(CompletionResultSet result, PsiElement position) {
        PsiClass parent = (PsiClass)CompletionUtil.getOriginalElement((PsiElement)ObjectUtils.assertNotNull((Object)PsiTreeUtil.getParentOfType((PsiElement)position, PsiClass.class)));
        if (parent != null) {
            HashSet addedSignatures = ContainerUtil.newHashSet();
            JavaGenerateMemberCompletionContributor.addGetterSetterElements(result, parent, addedSignatures);
            JavaGenerateMemberCompletionContributor.addSuperSignatureElements(parent, true, result, addedSignatures);
            JavaGenerateMemberCompletionContributor.addSuperSignatureElements(parent, false, result, addedSignatures);
        }
    }

    private static void addGetterSetterElements(CompletionResultSet result, PsiClass parent, Set<MethodSignature> addedSignatures) {
        int count = 0;
        for (PsiField field : parent.getFields()) {
            if (field instanceof PsiEnumConstant) continue;
            List prototypes = ContainerUtil.newSmartList();
            Collections.addAll(prototypes, GetterSetterPrototypeProvider.generateGetterSetters(field, true));
            Collections.addAll(prototypes, GetterSetterPrototypeProvider.generateGetterSetters(field, false));
            for (final PsiMethod prototype : prototypes) {
                if (parent.findMethodBySignature(prototype, false) != null || !addedSignatures.add(prototype.getSignature(PsiSubstitutor.EMPTY))) continue;
                Icon icon = prototype.getIcon(1);
                result.addElement((LookupElement)JavaGenerateMemberCompletionContributor.createGenerateMethodElement(prototype, PsiSubstitutor.EMPTY, icon, "", new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        JavaGenerateMemberCompletionContributor.removeLookupString(context);
                        JavaGenerateMemberCompletionContributor.insertGenerationInfos(context, Collections.singletonList(new PsiGenerationInfo<PsiMethod>(prototype)));
                    }
                }));
                if (count++ <= 100) continue;
                return;
            }
        }
    }

    private static void removeLookupString(InsertionContext context) {
        context.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
        context.commitDocument();
    }

    private static void addSuperSignatureElements(PsiClass parent, boolean implemented, CompletionResultSet result, Set<MethodSignature> addedSignatures) {
        for (CandidateInfo candidate : OverrideImplementExploreUtil.getMethodsToOverrideImplement(parent, implemented)) {
            PsiMethod baseMethod = (PsiMethod)candidate.getElement();
            PsiClass baseClass = baseMethod.getContainingClass();
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            if (baseMethod.isConstructor() || baseClass == null || !addedSignatures.add(baseMethod.getSignature(substitutor))) continue;
            result.addElement((LookupElement)JavaGenerateMemberCompletionContributor.createOverridingLookupElement(implemented, baseMethod, baseClass, substitutor));
        }
    }

    private static LookupElementBuilder createOverridingLookupElement(boolean implemented, final PsiMethod baseMethod, PsiClass baseClass, PsiSubstitutor substitutor) {
        RowIcon icon = new RowIcon(new Icon[]{baseMethod.getIcon(0), implemented ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod});
        return JavaGenerateMemberCompletionContributor.createGenerateMethodElement(baseMethod, substitutor, (Icon)icon, baseClass.getName(), new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                JavaGenerateMemberCompletionContributor.removeLookupString(context);
                PsiClass parent = (PsiClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiClass.class, (boolean)false);
                if (parent == null) {
                    return;
                }
                List<PsiMethod> prototypes = OverrideImplementUtil.overrideOrImplementMethod(parent, baseMethod, false);
                JavaGenerateMemberCompletionContributor.insertGenerationInfos(context, OverrideImplementUtil.convert2GenerationInfos(prototypes));
            }
        });
    }

    private static void insertGenerationInfos(InsertionContext context, List<PsiGenerationInfo<PsiMethod>> infos) {
        List<PsiGenerationInfo<PsiMethod>> newInfos = GenerateMembersUtil.insertMembersAtOffset(context.getFile(), context.getStartOffset(), infos);
        if (!newInfos.isEmpty()) {
            ArrayList<PsiMember> elements = new ArrayList<PsiMember>();
            for (GenerationInfo generationInfo : newInfos) {
                PsiMember psiMember;
                if (generationInfo instanceof TemplateGenerationInfo || (psiMember = generationInfo.getPsiMember()) == null) continue;
                elements.add(psiMember);
            }
            GlobalInspectionContextBase.cleanupElements(context.getProject(), null, elements.toArray(new PsiElement[elements.size()]));
            newInfos.get(0).positionCaret(context.getEditor(), true);
        }
    }

    private static LookupElementBuilder createGenerateMethodElement(PsiMethod prototype, PsiSubstitutor substitutor, Icon icon, String typeText, InsertHandler<LookupElement> insertHandler) {
        String methodName = prototype.getName();
        String visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)prototype.getModifierList());
        String modifiers = visibility == "packageLocal" ? "" : visibility + " ";
        PsiType type = substitutor.substitute(prototype.getReturnType());
        String signature = modifiers + (type == null ? "" : type.getPresentableText() + " ") + methodName;
        String parameters = PsiFormatUtil.formatMethod((PsiMethod)prototype, (PsiSubstitutor)substitutor, (int)256, (int)1);
        String overrideSignature = " @Override " + signature;
        LookupElementBuilder element = LookupElementBuilder.create((Object)prototype, (String)signature).withLookupString(methodName).withLookupString(signature).withLookupString(overrideSignature).withInsertHandler(insertHandler).appendTailText(parameters, false).appendTailText(" {...}", true).withTypeText(typeText).withIcon(icon);
        element.putUserData(GENERATE_ELEMENT, (Object)true);
        return element;
    }
}

