/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import org.jetbrains.annotations.NotNull;

public class PriorityWeigher
extends CompletionWeigher {
    public Double weigh(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/PriorityWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/codeInsight/completion/PriorityWeigher", "weigh"));
        }
        PrioritizedLookupElement prioritized = (PrioritizedLookupElement)element.as(PrioritizedLookupElement.CLASS_CONDITION_KEY);
        if (prioritized != null) {
            return prioritized.getPriority();
        }
        LookupItem item = (LookupItem)element.as(LookupItem.CLASS_CONDITION_KEY);
        if (item != null) {
            return item.getPriority();
        }
        return 0.0;
    }

    public static class Negative
    extends PriorityWeigher {
        @Override
        public Double weigh(@NotNull LookupElement element, @NotNull CompletionLocation location) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/PriorityWeigher$Negative", "weigh"));
            }
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/codeInsight/completion/PriorityWeigher$Negative", "weigh"));
            }
            return -super.weigh(element, location).doubleValue();
        }
    }
}

