/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class IdentifierHighlighterPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private static final int[] AFTER_PASSES = new int[]{4};
    private static boolean ourTestingIdentifierHighlighting = false;

    public IdentifierHighlighterPassFactory(Project project2, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project2);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, AFTER_PASSES, false, -1);
    }

    @Override
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPassFactory", "createHighlightingPass"));
        }
        if (!editor.isOneLineMode() && CodeInsightSettings.getInstance().HIGHLIGHT_IDENTIFIER_UNDER_CARET && (!ApplicationManager.getApplication().isHeadlessEnvironment() || ourTestingIdentifierHighlighting) && (file2.isPhysical() || file2.getOriginalFile().isPhysical())) {
            return new IdentifierHighlighterPass(file2.getProject(), file2, editor);
        }
        return null;
    }

    public static void doWithHighlightingEnabled(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPassFactory", "doWithHighlightingEnabled"));
        }
        ourTestingIdentifierHighlighting = true;
        try {
            r.run();
        }
        finally {
            ourTestingIdentifierHighlighting = false;
        }
    }
}

