/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReference;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlEncodingReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReferenceProvider");
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReferenceProvider", "getReferencesByElement"));
        }
        LOG.assertTrue(element instanceof XmlAttributeValue);
        XmlAttributeValue value = (XmlAttributeValue)element;
        PsiReference[] psiReferenceArray = new PsiReference[]{new XmlEncodingReference(value, value.getValue(), XmlEncodingReferenceProvider.xmlAttributeValueRange(value), 0)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    protected static TextRange xmlAttributeValueRange(XmlAttributeValue xmlAttributeValue) {
        ASTNode valueNode = XmlChildRole.ATTRIBUTE_VALUE_VALUE_FINDER.findChild(xmlAttributeValue.getNode());
        XmlAttributeValue toHighlight = valueNode == null ? xmlAttributeValue : valueNode.getPsi();
        TextRange childRange = toHighlight.getTextRange();
        TextRange range = xmlAttributeValue.getTextRange();
        return childRange.shiftRight(-range.getStartOffset());
    }

    public static PsiReference[] extractFromContentAttribute(XmlAttributeValue value) {
        String text = value.getValue();
        int start = text.indexOf(CHARSET_PREFIX);
        if (start != -1) {
            int end = text.indexOf(59, start += CHARSET_PREFIX.length());
            if (end == -1) {
                end = text.length();
            }
            String charsetName = text.substring(start, end);
            TextRange textRange = new TextRange(start, end).shiftRight(XmlEncodingReferenceProvider.xmlAttributeValueRange(value).getStartOffset());
            return new PsiReference[]{new XmlEncodingReference(value, charsetName, textRange, 0)};
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

