/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.actions.TypeCookAction;
import org.jetbrains.annotations.NotNull;

public class GenerifyFileFix
implements IntentionAction,
LocalQuickFix {
    private String myFileName;

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("generify.text", this.myFileName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("generify.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(final @NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        final PsiFile file2 = element.getContainingFile();
        if (this.isAvailable(project2, null, file2)) {
            this.myFileName = file2.getName();
            new WriteCommandAction(project2, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix$1", "run"));
                    }
                    GenerifyFileFix.this.invoke(project2, FileEditorManager.getInstance((Project)project2).getSelectedTextEditor(), file2);
                }
            }.execute();
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix", "isAvailable"));
        }
        if (file2 != null && file2.isValid()) {
            this.myFileName = file2.getName();
            return PsiManager.getInstance((Project)project2).isInProject((PsiElement)file2);
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        new TypeCookAction().getHandler().invoke(project2, editor, file2, null);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

