/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationPreviewPanelProvider
extends PreviewPanelProvider<Couple<PsiElement>, DocumentationComponent> {
    public static final PreviewProviderId<Couple<PsiElement>, DocumentationComponent> ID = PreviewProviderId.create("Documentation");
    private final DocumentationComponent myDocumentationComponent;
    private final DocumentationManager myDocumentationManager;

    public DocumentationPreviewPanelProvider(DocumentationManager documentationManager) {
        super(ID);
        this.myDocumentationManager = documentationManager;
        this.myDocumentationComponent = new DocumentationComponent(documentationManager){

            @Override
            public String toString() {
                return "Preview DocumentationComponent (" + (this.isEmpty() ? "empty" : "not empty") + ")";
            }
        };
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDocumentationComponent);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        DocumentationComponent documentationComponent = this.myDocumentationComponent;
        if (documentationComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "getComponent"));
        }
        return documentationComponent;
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull Couple<PsiElement> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "getTitle"));
        }
        String string = DocumentationManager.getTitle((PsiElement)content.getFirst(), false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "getTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    protected Icon getIcon(@NotNull Couple<PsiElement> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "getIcon"));
        }
        return ((PsiElement)content.getFirst()).getIcon(0);
    }

    @Override
    public float getMenuOrder() {
        return 1.0f;
    }

    @Override
    public void showInStandardPlace(@NotNull Couple<PsiElement> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "showInStandardPlace"));
        }
        this.myDocumentationManager.showJavaDocInfo((PsiElement)content.getFirst(), (PsiElement)content.getSecond());
    }

    @Override
    public void release(@NotNull Couple<PsiElement> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "release"));
        }
    }

    @Override
    public boolean contentsAreEqual(@NotNull Couple<PsiElement> content1, @NotNull Couple<PsiElement> content2) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "contentsAreEqual"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/codeInsight/documentation/DocumentationPreviewPanelProvider", "contentsAreEqual"));
        }
        return ((PsiElement)content1.getFirst()).getManager().areElementsEquivalent((PsiElement)content1.getFirst(), (PsiElement)content2.getFirst());
    }

    @Override
    public boolean isModified(Couple<PsiElement> content, boolean beforeReuse) {
        return beforeReuse;
    }

    @Override
    protected DocumentationComponent initComponent(Couple<PsiElement> content, boolean requestFocus) {
        if (!((PsiElement)content.getFirst()).getManager().areElementsEquivalent(this.myDocumentationComponent.getElement(), (PsiElement)content.getFirst())) {
            this.myDocumentationManager.fetchDocInfo((PsiElement)content.getFirst(), this.myDocumentationComponent);
        }
        return this.myDocumentationComponent;
    }
}

