/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.source.jsp.jspJava.JspMethodCall;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.Nullable;

public class MethodCallFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        PsiExpressionList args = null;
        if (psiElement instanceof PsiMethodCallExpression && !(psiElement instanceof JspMethodCall)) {
            args = ((PsiMethodCallExpression)psiElement).getArgumentList();
        } else if (psiElement instanceof PsiNewExpression) {
            args = ((PsiNewExpression)psiElement).getArgumentList();
        }
        if (args != null && !MethodCallFixer.hasRParenth(args)) {
            Integer argCount;
            PsiExpression[] params;
            int caret = editor.getCaretModel().getOffset();
            PsiCallExpression innermostCall = (PsiCallExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiElement.getContainingFile(), (int)(caret - 1), PsiCallExpression.class, (boolean)false);
            if (innermostCall == null) {
                return;
            }
            args = innermostCall.getArgumentList();
            if (args == null) {
                return;
            }
            int endOffset = -1;
            for (PsiElement child = args.getFirstChild(); child != null; child = child.getNextSibling()) {
                PsiErrorElement errorElement;
                if (!(child instanceof PsiErrorElement) || !(errorElement = (PsiErrorElement)child).getErrorDescription().contains("')'")) continue;
                endOffset = errorElement.getTextRange().getStartOffset();
                break;
            }
            if (endOffset == -1) {
                endOffset = args.getTextRange().getEndOffset();
            }
            if ((params = args.getExpressions()).length > 0 && MethodCallFixer.startLine(editor, (PsiElement)args) != MethodCallFixer.startLine(editor, (PsiElement)params[0]) && caret < params[0].getTextRange().getStartOffset()) {
                endOffset = args.getTextRange().getStartOffset() + 1;
            }
            if (!DumbService.isDumb((Project)args.getProject()) && (argCount = MethodCallFixer.getUnambiguousParameterCount(innermostCall)) != null && argCount > 0 && argCount < params.length) {
                endOffset = Math.min(endOffset, params[argCount - 1].getTextRange().getEndOffset());
            }
            endOffset = CharArrayUtil.shiftBackward((CharSequence)editor.getDocument().getCharsSequence(), (int)(endOffset - 1), (String)" \t\n") + 1;
            editor.getDocument().insertString(endOffset, (CharSequence)")");
        }
    }

    private static boolean hasRParenth(PsiExpressionList args) {
        PsiElement parenth = args.getLastChild();
        return parenth != null && ")".equals(parenth.getText());
    }

    @Nullable
    private static Integer getUnambiguousParameterCount(PsiCallExpression call) {
        int argCount = -1;
        for (CandidateInfo candidate : PsiResolveHelper.SERVICE.getInstance((Project)call.getProject()).getReferencedMethodCandidates(call, false)) {
            PsiElement element = candidate.getElement();
            if (!(element instanceof PsiMethod)) {
                return null;
            }
            if (((PsiMethod)element).isVarArgs()) {
                return null;
            }
            int count = ((PsiMethod)element).getParameterList().getParametersCount();
            if (argCount == -1) {
                argCount = count;
                continue;
            }
            if (argCount == count) continue;
            return null;
        }
        return argCount;
    }

    private static int startLine(Editor editor, PsiElement psiElement) {
        return editor.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

