/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.MethodImplementor;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.ImplementMethodsHandler;
import com.intellij.codeInsight.generation.JavaOverrideImplementMemberChooser;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.codeInsight.generation.OverrideMethodsHandler;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.ide.util.MemberChooser;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverrideImplementUtil
extends OverrideImplementExploreUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.OverrideImplementUtil");

    private OverrideImplementUtil() {
    }

    protected static MethodImplementor[] getImplementors() {
        return (MethodImplementor[])Extensions.getExtensions((ExtensionPointName)MethodImplementor.EXTENSION_POINT_NAME);
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethod(PsiClass aClass, PsiMethod method, boolean toCopyJavaDoc) throws IncorrectOperationException {
        PsiClass containingClass = method.getContainingClass();
        LOG.assertTrue(containingClass != null);
        PsiSubstitutor substitutor = aClass.isInheritor(containingClass, true) ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
        List<PsiMethod> list = OverrideImplementUtil.overrideOrImplementMethod(aClass, method, substitutor, toCopyJavaDoc, CodeStyleSettingsManager.getSettings((Project)aClass.getProject()).INSERT_OVERRIDE_ANNOTATION);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/OverrideImplementUtil", "overrideOrImplementMethod"));
        }
        return list;
    }

    public static boolean isInsertOverride(PsiMethod superMethod, PsiClass targetClass) {
        if (!CodeStyleSettingsManager.getSettings((Project)targetClass.getProject()).INSERT_OVERRIDE_ANNOTATION) {
            return false;
        }
        return OverrideImplementUtil.canInsertOverride(superMethod, targetClass);
    }

    public static boolean canInsertOverride(PsiMethod superMethod, PsiClass targetClass) {
        if (superMethod.isConstructor() || superMethod.hasModifierProperty("static")) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)targetClass)) {
            return false;
        }
        if (PsiUtil.isLanguageLevel6OrHigher((PsiElement)targetClass)) {
            return true;
        }
        PsiClass superClass = superMethod.getContainingClass();
        return superClass != null && !superClass.isInterface();
    }

    public static List<PsiMethod> overrideOrImplementMethod(PsiClass aClass, PsiMethod method, PsiSubstitutor substitutor, boolean toCopyJavaDoc, boolean insertOverrideIfPossible) throws IncorrectOperationException {
        if (!method.isValid() || !substitutor.isValid()) {
            return Collections.emptyList();
        }
        ArrayList<PsiMethod> results = new ArrayList<PsiMethod>();
        for (MethodImplementor implementor : OverrideImplementUtil.getImplementors()) {
            PsiMethod[] prototypes;
            for (PsiMethod prototype : prototypes = implementor.createImplementationPrototypes(aClass, method)) {
                implementor.createDecorator(aClass, method, toCopyJavaDoc, insertOverrideIfPossible).consume((Object)prototype);
                results.add(prototype);
            }
        }
        if (results.isEmpty()) {
            PsiAnnotationMemberValue defaultValue;
            PsiMethod method1 = GenerateMembersUtil.substituteGenericMethod(method, substitutor, (PsiElement)aClass);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
            PsiMethod result = (PsiMethod)factory.createClass("Dummy").add((PsiElement)method1);
            if (PsiUtil.isAnnotationMethod((PsiElement)result) && (defaultValue = ((PsiAnnotationMethod)result).getDefaultValue()) != null) {
                PsiAnnotationMemberValue defaultKeyword;
                for (defaultKeyword = defaultValue; !(defaultKeyword instanceof PsiKeyword) && defaultKeyword != null; defaultKeyword = defaultKeyword.getPrevSibling()) {
                }
                if (defaultKeyword == null) {
                    defaultKeyword = defaultValue;
                }
                defaultValue.getParent().deleteChildRange((PsiElement)defaultKeyword, (PsiElement)defaultValue);
            }
            Consumer<PsiMethod> decorator = OverrideImplementUtil.createDefaultDecorator(aClass, method, toCopyJavaDoc, insertOverrideIfPossible);
            decorator.consume((Object)result);
            results.add(result);
        }
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            if (aClass.findMethodBySignature((PsiMethod)iterator.next(), false) == null) continue;
            iterator.remove();
        }
        return results;
    }

    public static Consumer<PsiMethod> createDefaultDecorator(final PsiClass aClass, final PsiMethod method, final boolean toCopyJavaDoc, final boolean insertOverrideIfPossible) {
        return new Consumer<PsiMethod>(){

            public void consume(PsiMethod result) {
                OverrideImplementUtil.decorateMethod(aClass, method, toCopyJavaDoc, insertOverrideIfPossible, result);
            }
        };
    }

    private static PsiMethod decorateMethod(PsiClass aClass, PsiMethod method, boolean toCopyJavaDoc, boolean insertOverrideIfPossible, PsiMethod result) {
        PsiClass containingClass;
        PsiTypeParameterList list;
        PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"abstract", (boolean)aClass.isInterface());
        PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"native", (boolean)false);
        if (!toCopyJavaDoc) {
            OverrideImplementUtil.deleteDocComment(result);
        }
        if ((list = result.getTypeParameterList()) != null && (containingClass = method.getContainingClass()) != null) {
            for (PsiClassType classType : aClass.getSuperTypes()) {
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)PsiUtil.resolveClassInType((PsiType)classType), (PsiClass)containingClass, (boolean)true) || !classType.isRaw()) continue;
                list.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createTypeParameterList());
                break;
            }
        }
        OverrideImplementUtil.annotateOnOverrideImplement(result, aClass, method, insertOverrideIfPossible);
        if (CodeStyleSettingsManager.getSettings((Project)aClass.getProject()).REPEAT_SYNCHRONIZED && method.hasModifierProperty("synchronized")) {
            result.getModifierList().setModifierProperty("synchronized", true);
        }
        PsiCodeBlock body = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createCodeBlockFromText("{}", null);
        PsiCodeBlock oldBody = result.getBody();
        if (oldBody != null) {
            oldBody.replace((PsiElement)body);
        } else {
            result.add((PsiElement)body);
        }
        OverrideImplementUtil.setupMethodBody(result, method, aClass);
        Project project2 = method.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        CommonCodeStyleSettings javaSettings = CodeStyleSettingsManager.getSettings((Project)project2).getCommonSettings((Language)JavaLanguage.INSTANCE);
        boolean keepBreaks = javaSettings.KEEP_LINE_BREAKS;
        javaSettings.KEEP_LINE_BREAKS = false;
        result = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)result);
        result = (PsiMethod)codeStyleManager.reformat((PsiElement)result);
        javaSettings.KEEP_LINE_BREAKS = keepBreaks;
        return result;
    }

    public static void deleteDocComment(PsiMethod result) {
        PsiDocComment comment = result.getDocComment();
        if (comment != null) {
            comment.delete();
        }
    }

    public static void annotateOnOverrideImplement(PsiMethod method, PsiClass targetClass, PsiMethod overridden) {
        OverrideImplementUtil.annotateOnOverrideImplement(method, targetClass, overridden, CodeStyleSettingsManager.getSettings((Project)method.getProject()).INSERT_OVERRIDE_ANNOTATION);
    }

    public static void annotateOnOverrideImplement(PsiMethod method, PsiClass targetClass, PsiMethod overridden, boolean insertOverride) {
        Module module2;
        String overrideAnnotationName;
        if (insertOverride && OverrideImplementUtil.canInsertOverride(overridden, targetClass) && !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)(overrideAnnotationName = Override.class.getName()), (boolean)false, (boolean)true)) {
            AddAnnotationPsiFix.addPhysicalAnnotation(overrideAnnotationName, PsiNameValuePair.EMPTY_ARRAY, method.getModifierList());
        }
        GlobalSearchScope moduleScope = (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)targetClass)) != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2) : null;
        Project project2 = targetClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        for (OverrideImplementsAnnotationsHandler each : (OverrideImplementsAnnotationsHandler[])Extensions.getExtensions(OverrideImplementsAnnotationsHandler.EP_NAME)) {
            for (String annotation : each.getAnnotations(project2)) {
                PsiAnnotation psiAnnotation;
                if (moduleScope != null && facade.findClass(annotation, moduleScope) == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)overridden, (String)annotation, (boolean)false, (boolean)false) || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)annotation, (boolean)false, (boolean)false) || (psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)overridden, (String[])new String[]{annotation})) != null && AnnotationUtil.isInferredAnnotation((PsiAnnotation)psiAnnotation)) continue;
                AddAnnotationPsiFix.removePhysicalAnnotations((PsiModifierListOwner)method, each.annotationsToRemove(project2, annotation));
                AddAnnotationPsiFix.addPhysicalAnnotation(annotation, PsiNameValuePair.EMPTY_ARRAY, method.getModifierList());
            }
        }
    }

    public static void annotate(@NotNull PsiMethod result, String fqn, String ... annosToRemove) throws IncorrectOperationException {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/generation/OverrideImplementUtil", "annotate"));
        }
        AddAnnotationFix fix = new AddAnnotationFix(fqn, (PsiModifierListOwner)result, annosToRemove);
        Project project2 = result.getProject();
        if (fix.isAvailable(project2, null, result.getContainingFile())) {
            fix.invoke(project2, null, result.getContainingFile());
        }
    }

    @NotNull
    public static List<PsiGenerationInfo<PsiMethod>> overrideOrImplementMethods(PsiClass aClass, Collection<PsiMethodMember> candidates, boolean toCopyJavaDoc, boolean toInsertAtOverride) throws IncorrectOperationException {
        List candidateInfos = ContainerUtil.map2List(candidates, (Function)new Function<PsiMethodMember, CandidateInfo>(){

            public CandidateInfo fun(PsiMethodMember s) {
                return new CandidateInfo(s.getElement(), s.getSubstitutor());
            }
        });
        List<PsiMethod> methods = OverrideImplementUtil.overrideOrImplementMethodCandidates(aClass, candidateInfos, toCopyJavaDoc, toInsertAtOverride);
        List<PsiGenerationInfo<PsiMethod>> list = OverrideImplementUtil.convert2GenerationInfos(methods);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/OverrideImplementUtil", "overrideOrImplementMethods"));
        }
        return list;
    }

    @NotNull
    public static List<PsiMethod> overrideOrImplementMethodCandidates(PsiClass aClass, Collection<CandidateInfo> candidates, boolean toCopyJavaDoc, boolean insertOverrideWherePossible) throws IncorrectOperationException {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (CandidateInfo candidateInfo : candidates) {
            result.addAll(OverrideImplementUtil.overrideOrImplementMethod(aClass, (PsiMethod)candidateInfo.getElement(), candidateInfo.getSubstitutor(), toCopyJavaDoc, insertOverrideWherePossible));
        }
        ArrayList<PsiMethod> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/OverrideImplementUtil", "overrideOrImplementMethodCandidates"));
        }
        return arrayList;
    }

    public static List<PsiGenerationInfo<PsiMethod>> convert2GenerationInfos(Collection<PsiMethod> methods) {
        return ContainerUtil.map2List(methods, (Function)new Function<PsiMethod, PsiGenerationInfo<PsiMethod>>(){

            public PsiGenerationInfo<PsiMethod> fun(PsiMethod s) {
                return OverrideImplementUtil.createGenerationInfo(s);
            }
        });
    }

    public static PsiGenerationInfo<PsiMethod> createGenerationInfo(PsiMethod s) {
        return OverrideImplementUtil.createGenerationInfo(s, true);
    }

    public static PsiGenerationInfo<PsiMethod> createGenerationInfo(PsiMethod s, boolean mergeIfExists) {
        for (MethodImplementor implementor : OverrideImplementUtil.getImplementors()) {
            GenerationInfo info = implementor.createGenerationInfo(s, mergeIfExists);
            if (!(info instanceof PsiGenerationInfo)) continue;
            PsiGenerationInfo psiGenerationInfo = (PsiGenerationInfo)info;
            return psiGenerationInfo;
        }
        return new PsiGenerationInfo<PsiMethod>(s);
    }

    @NotNull
    public static String callSuper(PsiMethod superMethod, PsiMethod overriding) {
        StringBuilder buffer = new StringBuilder();
        if (!superMethod.isConstructor() && !PsiType.VOID.equals((Object)superMethod.getReturnType())) {
            buffer.append("return ");
        }
        buffer.append("super");
        PsiParameter[] parameters = overriding.getParameterList().getParameters();
        if (!superMethod.isConstructor()) {
            buffer.append(".");
            buffer.append(superMethod.getName());
        }
        buffer.append("(");
        for (int i = 0; i < parameters.length; ++i) {
            String name = parameters[i].getName();
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(name);
        }
        buffer.append(")");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/OverrideImplementUtil", "callSuper"));
        }
        return string;
    }

    public static void setupMethodBody(PsiMethod result, PsiMethod originalMethod, PsiClass targetClass) throws IncorrectOperationException {
        boolean isAbstract = originalMethod.hasModifierProperty("abstract") || originalMethod.hasModifierProperty("default");
        String templateName = isAbstract ? "Implemented Method Body.java" : "Overridden Method Body.java";
        FileTemplate template = FileTemplateManager.getInstance(originalMethod.getProject()).getCodeTemplate(templateName);
        OverrideImplementUtil.setupMethodBody(result, originalMethod, targetClass, template);
    }

    public static void setupMethodBody(PsiMethod result, PsiMethod originalMethod, PsiClass targetClass, FileTemplate template) throws IncorrectOperationException {
        String methodText;
        if (targetClass.isInterface()) {
            if (OverrideImplementUtil.isImplementInterfaceInJava8Interface(targetClass)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)result, (String)"default", (boolean)true);
            } else {
                PsiCodeBlock body = result.getBody();
                if (body != null) {
                    body.delete();
                }
            }
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(template.getExtension());
        PsiType returnType = result.getReturnType();
        if (returnType == null) {
            returnType = PsiType.VOID;
        }
        Properties properties = FileTemplateManager.getInstance(targetClass.getProject()).getDefaultProperties();
        properties.setProperty("RETURN_TYPE", returnType.getPresentableText());
        properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)returnType));
        properties.setProperty("CALL_SUPER", OverrideImplementUtil.callSuper(originalMethod, result));
        JavaTemplateUtil.setClassAndMethodNameProperties(properties, targetClass, result);
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)originalMethod.getProject());
        if (factory == null) {
            factory = JavaPsiFacade.getInstance((Project)originalMethod.getProject()).getElementFactory();
        }
        try {
            methodText = "void foo () {\n" + template.getText(properties) + "\n}";
            methodText = FileTemplateUtil.indent(methodText, result.getProject(), fileType);
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Failed to parse file template", (Throwable)e);
        }
        if (methodText != null) {
            PsiMethod m;
            try {
                m = factory.createMethodFromText(methodText, (PsiElement)originalMethod);
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)CodeInsightBundle.message((String)"override.implement.broken.file.template.message", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"override.implement.broken.file.template.title", (Object[])new Object[0]));
                    }
                });
                return;
            }
            PsiCodeBlock oldBody = result.getBody();
            if (oldBody != null) {
                oldBody.replace((PsiElement)m.getBody());
            }
        }
    }

    private static boolean isImplementInterfaceInJava8Interface(PsiClass targetClass) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)targetClass)) {
            return false;
        }
        String implementMethodsName = ActionsBundle.message((String)"action.ImplementMethods.text", (Object[])new Object[0]);
        Presentation presentation = new Presentation();
        presentation.setText(implementMethodsName);
        return presentation.getText().equals(CommandProcessor.getInstance().getCurrentCommandName());
    }

    public static void chooseAndOverrideMethods(Project project2, Editor editor, PsiClass aClass) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        OverrideImplementUtil.chooseAndOverrideOrImplementMethods(project2, editor, aClass, false);
    }

    public static void chooseAndImplementMethods(Project project2, Editor editor, PsiClass aClass) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        OverrideImplementUtil.chooseAndOverrideOrImplementMethods(project2, editor, aClass, true);
    }

    public static void chooseAndOverrideOrImplementMethods(Project project2, final Editor editor, final PsiClass aClass, boolean toImplement) {
        LOG.assertTrue(aClass.isValid());
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<CandidateInfo> candidates = OverrideImplementUtil.getMethodsToOverrideImplement(aClass, toImplement);
        ArrayList secondary = toImplement || aClass.isInterface() ? ContainerUtil.newArrayList() : OverrideImplementUtil.getMethodsToOverrideImplement(aClass, true);
        final MemberChooser<PsiMethodMember> chooser = OverrideImplementUtil.showOverrideImplementChooser(editor, (PsiElement)aClass, toImplement, candidates, secondary);
        if (chooser == null) {
            return;
        }
        final List<PsiMethodMember> selectedElements = chooser.getSelectedElements();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return;
        }
        LOG.assertTrue(aClass.isValid());
        new WriteCommandAction(project2, new PsiFile[]{aClass.getContainingFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/generation/OverrideImplementUtil$5", "run"));
                }
                OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor, aClass, selectedElements, chooser.isCopyJavadoc(), chooser.isInsertOverrideAnnotation());
            }
        }.execute();
    }

    @Nullable
    public static MemberChooser<PsiMethodMember> showOverrideImplementChooser(Editor editor, PsiElement aClass, boolean toImplement, Collection<CandidateInfo> candidates, Collection<CandidateInfo> secondary) {
        JavaOverrideImplementMemberChooser chooser;
        if (toImplement) {
            Iterator<CandidateInfo> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                CandidateInfo candidate = iterator.next();
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod) || !((PsiMethod)element).hasModifierProperty("default")) continue;
                iterator.remove();
                secondary.add(candidate);
            }
        }
        if ((chooser = JavaOverrideImplementMemberChooser.create(aClass, toImplement, candidates, secondary)) == null) {
            return null;
        }
        Project project2 = aClass.getProject();
        OverrideImplementUtil.registerHandlerForComplementaryAction(project2, editor, aClass, toImplement, chooser);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return chooser;
        }
        chooser.show();
        if (chooser.getExitCode() != 0) {
            return null;
        }
        return chooser;
    }

    private static void registerHandlerForComplementaryAction(final Project project2, final Editor editor, final PsiElement aClass, final boolean toImplement, final MemberChooser<PsiMethodMember> chooser) {
        String s;
        JComponent preferredFocusedComponent = chooser.getPreferredFocusedComponent();
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts(s = toImplement ? "OverrideMethods" : "ImplementMethods");
        if (shortcuts.length > 0 && shortcuts[0] instanceof KeyboardShortcut) {
            preferredFocusedComponent.getInputMap().put(((KeyboardShortcut)shortcuts[0]).getFirstKeyStroke(), s);
            preferredFocusedComponent.getActionMap().put(s, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    chooser.close(1);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Object handler2 = toImplement ? new OverrideMethodsHandler() : new ImplementMethodsHandler();
                            handler2.invoke(project2, editor, aClass.getContainingFile());
                        }
                    });
                }
            });
        }
    }

    public static void overrideOrImplementMethodsInRightPlace(Editor editor, PsiClass aClass, Collection<PsiMethodMember> candidates, boolean copyJavadoc, boolean insertOverrideWherePossible) {
        try {
            List<Object> resultMembers;
            int lbraceOffset;
            int offset = editor.getCaretModel().getOffset();
            PsiElement brace = aClass.getLBrace();
            if (brace == null) {
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createClass("X");
                brace = aClass.addRangeAfter(psiClass.getLBrace(), psiClass.getRBrace(), aClass.getLastChild());
                LOG.assertTrue(brace != null, (Object)aClass.getLastChild());
            }
            if (offset <= (lbraceOffset = brace.getTextOffset()) || aClass.isEnum()) {
                resultMembers = new ArrayList();
                for (PsiMethodMember candidate : candidates) {
                    List<PsiMethod> prototypes = OverrideImplementUtil.overrideOrImplementMethod(aClass, (PsiMethod)candidate.getElement(), candidate.getSubstitutor(), copyJavadoc, insertOverrideWherePossible);
                    List<PsiGenerationInfo<PsiMethod>> infos = OverrideImplementUtil.convert2GenerationInfos(prototypes);
                    for (PsiGenerationInfo<PsiMethod> info : infos) {
                        PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement(aClass, (PsiMethod)candidate.getElement(), candidate.getSubstitutor());
                        info.insert(aClass, anchor, true);
                        resultMembers.add(info);
                    }
                }
            } else {
                List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.overrideOrImplementMethods(aClass, candidates, copyJavadoc, insertOverrideWherePossible);
                resultMembers = GenerateMembersUtil.insertMembersAtOffset(aClass.getContainingFile(), offset, prototypes);
            }
            if (!resultMembers.isEmpty()) {
                ((PsiGenerationInfo)resultMembers.get(0)).positionCaret(editor, true);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public static PsiElement getDefaultAnchorToOverrideOrImplement(PsiClass aClass, PsiMethod baseMethod, PsiSubstitutor substitutor) {
        PsiMethod prevBaseMethod = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)baseMethod, PsiMethod.class);
        while (prevBaseMethod != null) {
            MethodSignature signature;
            PsiMethod prevMethod;
            String name;
            String string = name = prevBaseMethod.isConstructor() ? aClass.getName() : prevBaseMethod.getName();
            if (name != null && (prevMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)(signature = MethodSignatureUtil.createMethodSignature((String)name, (PsiParameterList)prevBaseMethod.getParameterList(), (PsiTypeParameterList)prevBaseMethod.getTypeParameterList(), (PsiSubstitutor)substitutor, (boolean)prevBaseMethod.isConstructor())), (boolean)false)) != null && prevMethod.isPhysical()) {
                return prevMethod.getNextSibling();
            }
            prevBaseMethod = (PsiMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevBaseMethod, PsiMethod.class);
        }
        PsiMethod nextBaseMethod = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)baseMethod, PsiMethod.class);
        while (nextBaseMethod != null) {
            MethodSignature signature;
            PsiMethod nextMethod;
            String name;
            String string = name = nextBaseMethod.isConstructor() ? aClass.getName() : nextBaseMethod.getName();
            if (name != null && (nextMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)(signature = MethodSignatureUtil.createMethodSignature((String)name, (PsiParameterList)nextBaseMethod.getParameterList(), (PsiTypeParameterList)nextBaseMethod.getTypeParameterList(), (PsiSubstitutor)substitutor, (boolean)nextBaseMethod.isConstructor())), (boolean)false)) != null && nextMethod.isPhysical()) {
                return nextMethod;
            }
            nextBaseMethod = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextBaseMethod, PsiMethod.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PsiGenerationInfo<PsiMethod>> overrideOrImplement(PsiClass psiClass, @NotNull PsiMethod baseMethod) throws IncorrectOperationException {
        if (baseMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethod", "com/intellij/codeInsight/generation/OverrideImplementUtil", "overrideOrImplement"));
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)baseMethod.getProject());
        List<Object> results = new ArrayList();
        try {
            List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.convert2GenerationInfos(OverrideImplementUtil.overrideOrImplementMethod(psiClass, baseMethod, false));
            if (prototypes.isEmpty()) {
                List<PsiGenerationInfo<PsiMethod>> list = null;
                return list;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseMethod.getContainingClass(), (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiElement anchor = OverrideImplementUtil.getDefaultAnchorToOverrideOrImplement(psiClass, baseMethod, substitutor);
            List<Object> list = results = GenerateMembersUtil.insertMembersBeforeAnchor(psiClass, anchor, prototypes);
            return list;
        }
        finally {
            PsiFile psiFile = psiClass.getContainingFile();
            Editor editor = fileEditorManager.openTextEditor(new OpenFileDescriptor(psiFile.getProject(), psiFile.getVirtualFile()), true);
            if (editor != null && !results.isEmpty()) {
                ((PsiGenerationInfo)results.get(0)).positionCaret(editor, true);
                editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
        }
    }

    @Nullable
    public static PsiClass getContextClass(Project project2, Editor editor, PsiFile file2, boolean allowInterface) {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        while ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiTypeParameter) {
        }
        PsiClass aClass = (PsiClass)element;
        if (aClass instanceof PsiSyntheticClass) {
            return null;
        }
        return aClass == null || !allowInterface && aClass.isInterface() ? null : aClass;
    }

    public static void overrideOrImplementMethodsInRightPlace(Editor editor1, PsiClass aClass, Collection<PsiMethodMember> members, boolean copyJavadoc) {
        boolean insert = CodeStyleSettingsManager.getSettings((Project)aClass.getProject()).INSERT_OVERRIDE_ANNOTATION;
        OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor1, aClass, members, copyJavadoc, insert);
    }

    public static List<PsiMethod> overrideOrImplementMethodCandidates(PsiClass aClass, Collection<CandidateInfo> candidatesToImplement, boolean copyJavadoc) throws IncorrectOperationException {
        boolean insert = CodeStyleSettingsManager.getSettings((Project)aClass.getProject()).INSERT_OVERRIDE_ANNOTATION;
        return OverrideImplementUtil.overrideOrImplementMethodCandidates(aClass, candidatesToImplement, copyJavadoc, insert);
    }
}

