/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightImportedElementsHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiKeyword;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightImportedElementsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    @Override
    @Nullable
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull PsiElement target) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightImportedElementsHandlerFactory", "createHighlightUsagesHandler"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/highlighting/HighlightImportedElementsHandlerFactory", "createHighlightUsagesHandler"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/highlighting/HighlightImportedElementsHandlerFactory", "createHighlightUsagesHandler"));
        }
        if (!(target instanceof PsiKeyword) || !"import".equals(target.getText())) {
            return null;
        }
        PsiElement parent = target.getParent();
        if (!(parent instanceof PsiImportStatementBase)) {
            return null;
        }
        PsiElement grand = parent.getParent();
        if (!(grand instanceof PsiImportList)) {
            return null;
        }
        return new HighlightImportedElementsHandler(editor, file2, target, (PsiImportStatementBase)parent);
    }
}

