/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class TooltipController {
    private LightweightHint myCurrentTooltip;
    private TooltipRenderer myCurrentTooltipObject;
    private TooltipGroup myCurrentTooltipGroup;

    public static TooltipController getInstance() {
        return (TooltipController)ServiceManager.getService(TooltipController.class);
    }

    public void cancelTooltips() {
        this.hideCurrentTooltip();
    }

    public void cancelTooltip(@NotNull TooltipGroup groupId, MouseEvent mouseEvent, boolean forced) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/codeInsight/hint/TooltipController", "cancelTooltip"));
        }
        if (groupId.equals(this.myCurrentTooltipGroup)) {
            if (!forced && this.myCurrentTooltip != null && this.myCurrentTooltip.canControlAutoHide()) {
                return;
            }
            this.cancelTooltips();
        }
    }

    public void showTooltipByMouseMove(@NotNull Editor editor, @NotNull RelativePoint point, TooltipRenderer tooltipObject, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/TooltipController", "showTooltipByMouseMove"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/codeInsight/hint/TooltipController", "showTooltipByMouseMove"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInsight/hint/TooltipController", "showTooltipByMouseMove"));
        }
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/codeInsight/hint/TooltipController", "showTooltipByMouseMove"));
        }
        LightweightHint currentTooltip = this.myCurrentTooltip;
        if (currentTooltip == null || !currentTooltip.isVisible()) {
            if (currentTooltip != null) {
                if (!IdeTooltipManager.getInstance().isQueuedToShow(currentTooltip.getCurrentIdeTooltip())) {
                    this.myCurrentTooltipObject = null;
                }
            } else {
                this.myCurrentTooltipObject = null;
            }
        }
        if (Comparing.equal((Object)tooltipObject, (Object)this.myCurrentTooltipObject)) {
            IdeTooltipManager.getInstance().cancelAutoHide();
            return;
        }
        this.hideCurrentTooltip();
        if (tooltipObject != null) {
            Project project2;
            Point p = point.getPointOn((Component)editor.getComponent().getRootPane().getLayeredPane()).getPoint();
            if (!hintHint.isAwtTooltip()) {
                p.x = p.x + (alignToRight ? -10 : 10);
            }
            if ((project2 = editor.getProject()) != null && !project2.isOpen()) {
                return;
            }
            if (editor.getContentComponent().isShowing()) {
                this.showTooltip(editor, p, tooltipObject, alignToRight, group, hintHint);
            }
        }
    }

    private void hideCurrentTooltip() {
        if (this.myCurrentTooltip != null) {
            LightweightHint currentTooltip = this.myCurrentTooltip;
            this.myCurrentTooltip = null;
            currentTooltip.hide();
            this.myCurrentTooltipGroup = null;
            IdeTooltipManager.getInstance().hide(null);
        }
    }

    public void showTooltip(@NotNull Editor editor, @NotNull Point p, @NotNull String text, boolean alignToRight, @NotNull TooltipGroup group) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        TooltipRenderer tooltipRenderer = ((EditorMarkupModel)editor.getMarkupModel()).getErrorStripTooltipRendererProvider().calcTooltipRenderer(text);
        this.showTooltip(editor, p, tooltipRenderer, alignToRight, group);
    }

    public void showTooltip(@NotNull Editor editor, @NotNull Point p, @NotNull String text, int currentWidth, boolean alignToRight, @NotNull TooltipGroup group) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        TooltipRenderer tooltipRenderer = ((EditorMarkupModel)editor.getMarkupModel()).getErrorStripTooltipRendererProvider().calcTooltipRenderer(text, currentWidth);
        this.showTooltip(editor, p, tooltipRenderer, alignToRight, group);
    }

    public void showTooltip(@NotNull Editor editor, @NotNull Point p, @NotNull String text, int currentWidth, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        TooltipRenderer tooltipRenderer = ((EditorMarkupModel)editor.getMarkupModel()).getErrorStripTooltipRendererProvider().calcTooltipRenderer(text, currentWidth);
        this.showTooltip(editor, p, tooltipRenderer, alignToRight, group, hintHint);
    }

    public void showTooltip(@NotNull Editor editor, @NotNull Point p, @NotNull TooltipRenderer tooltipRenderer, boolean alignToRight, @NotNull TooltipGroup group) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (tooltipRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltipRenderer", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        this.showTooltip(editor, p, tooltipRenderer, alignToRight, group, new HintHint(editor, p));
    }

    public void showTooltip(@NotNull Editor editor, @NotNull Point p, @NotNull TooltipRenderer tooltipRenderer, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintInfo) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (tooltipRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tooltipRenderer", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (hintInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintInfo", "com/intellij/codeInsight/hint/TooltipController", "showTooltip"));
        }
        if (this.myCurrentTooltip == null || !this.myCurrentTooltip.isVisible()) {
            this.myCurrentTooltipObject = null;
        }
        if (Comparing.equal((Object)tooltipRenderer, (Object)this.myCurrentTooltipObject)) {
            IdeTooltipManager.getInstance().cancelAutoHide();
            return;
        }
        if (this.myCurrentTooltipGroup != null && group.compareTo(this.myCurrentTooltipGroup) < 0) {
            return;
        }
        p = new Point(p);
        this.hideCurrentTooltip();
        LightweightHint hint = tooltipRenderer.show(editor, p, alignToRight, group, hintInfo);
        this.myCurrentTooltipGroup = group;
        this.myCurrentTooltip = hint;
        this.myCurrentTooltipObject = tooltipRenderer;
    }

    public boolean shouldSurvive(MouseEvent e) {
        return this.myCurrentTooltip != null && this.myCurrentTooltip.canControlAutoHide();
    }

    public void hide(LightweightHint lightweightHint) {
        if (this.myCurrentTooltip != null && this.myCurrentTooltip.equals(lightweightHint)) {
            this.hideCurrentTooltip();
        }
    }

    public void resetCurrent() {
        this.myCurrentTooltip = null;
        this.myCurrentTooltipGroup = null;
        this.myCurrentTooltipObject = null;
    }
}

