/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.hint.actions.ShowImplementationsAction;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class ShowSiblingsAction
extends ShowImplementationsAction {
    @Override
    public void performForContext(@NotNull DataContext dataContext, final boolean invokedByShortcut) {
        Object[] superElements;
        PsiFile containingFile;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/hint/actions/ShowSiblingsAction", "performForContext"));
        }
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        final Editor editor = ShowSiblingsAction.getEditor(dataContext);
        PsiElement element = ShowSiblingsAction.getElement(project2, file2, editor, (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext));
        if (element == null && file2 == null) {
            return;
        }
        PsiFile psiFile = containingFile = element != null ? element.getContainingFile() : file2;
        if (containingFile == null || !containingFile.getViewProvider().isPhysical()) {
            return;
        }
        if (editor != null) {
            PsiReference ref = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset());
            if (element == null && ref != null) {
                element = TargetElementUtil.getInstance().adjustReference(ref);
            }
        }
        if ((superElements = ShowSiblingsAction.findSuperElements(element)).length == 0) {
            return;
        }
        boolean isMethod = superElements[0] instanceof PsiMethod;
        NavigatablePsiElement[] navigatablePsiElements = (NavigatablePsiElement[])ContainerUtil.findAllAsArray((Object[])superElements, NavigatablePsiElement.class);
        JBPopup popup = PsiElementListNavigator.navigateOrCreatePopup(navigatablePsiElements, "Choose super " + (isMethod ? "method" : "class or interface"), "Super " + (isMethod ? "methods" : "classes/interfaces"), isMethod ? new MethodCellRenderer(false) : new PsiClassListCellRenderer(), null, new Consumer<Object[]>(){

            public void consume(Object[] objects) {
                ShowSiblingsAction.this.showSiblings(invokedByShortcut, project2, editor, file2, editor != null, (PsiElement)objects[0]);
            }
        });
        if (popup != null) {
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project2);
            }
        }
    }

    private void showSiblings(boolean invokedByShortcut, @NotNull Project project2, Editor editor, PsiFile file2, boolean invokedFromEditor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/hint/actions/ShowSiblingsAction", "showSiblings"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/hint/actions/ShowSiblingsAction", "showSiblings"));
        }
        PsiElement[] impls = ShowSiblingsAction.getSelfAndImplementations(editor, element, ShowSiblingsAction.createImplementationsSearcher(), false);
        String text = SymbolPresentationUtil.getSymbolPresentableText(element);
        this.showImplementations(impls, project2, text, editor, file2, element, invokedFromEditor, invokedByShortcut);
    }

    @Override
    protected boolean isIncludeAlwaysSelf() {
        return false;
    }

    @NotNull
    private static PsiElement[] findSuperElements(PsiElement element) {
        PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/actions/ShowSiblingsAction", "findSuperElements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = FindSuperElementsHelper.findSuperElements((PsiElement)parent);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/actions/ShowSiblingsAction", "findSuperElements"));
        }
        return psiElementArray;
    }
}

