/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.LangBundle;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;

public class MethodNameMacro
extends Macro {
    public String getName() {
        return "methodName";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.methodname", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/MethodNameMacro", "getDefaultValue"));
        }
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/MethodNameMacro", "calculateResult"));
        }
        for (PsiElement place = context.getPsiElementAtStartOffset(); place != null; place = place.getParent()) {
            if (place instanceof PsiMethod) {
                return new TextResult(((PsiMethod)place).getName());
            }
            if (!(place instanceof PsiClassInitializer)) continue;
            return ((PsiClassInitializer)place).hasModifierProperty("static") ? new TextResult(LangBundle.message("java.terms.static.initializer", new Object[0])) : new TextResult(LangBundle.message("java.terms.instance.initializer", new Object[0]));
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

