/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TrivialMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/TrivialMethodReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                PsiElement resolve;
                PsiType functionalInterfaceType;
                PsiMethod interfaceMethod;
                PsiType qualifierType;
                PsiExpression qualifierExpression = expression.getQualifierExpression();
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                if (qualifierExpression != null && referenceNameElement != null && (qualifierType = qualifierExpression.getType()) != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(functionalInterfaceType = expression.getFunctionalInterfaceType()))) != null && (resolve = expression.resolve()) instanceof PsiMethod && (interfaceMethod == resolve || MethodSignatureUtil.isSuperMethod((PsiMethod)interfaceMethod, (PsiMethod)((PsiMethod)resolve))) && TypeConversionUtil.isAssignable((PsiType)functionalInterfaceType, (PsiType)qualifierType)) {
                    holder.registerProblem(referenceNameElement, "Method reference can be replaced with qualifier", new LocalQuickFix[]{new ReplaceMethodRefWithQualifierFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialMethodReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class ReplaceMethodRefWithQualifierFix
    implements LocalQuickFix {
        private ReplaceMethodRefWithQualifierFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialMethodReferenceInspection$ReplaceMethodRefWithQualifierFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with qualifier" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialMethodReferenceInspection$ReplaceMethodRefWithQualifierFix", "getFamilyName"));
            }
            return "Replace with qualifier";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiExpression qualifierExpression;
            PsiElement parent;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/TrivialMethodReferenceInspection$ReplaceMethodRefWithQualifierFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/TrivialMethodReferenceInspection$ReplaceMethodRefWithQualifierFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiElement psiElement = parent = element != null ? element.getParent() : null;
            if (parent instanceof PsiMethodReferenceExpression && (qualifierExpression = ((PsiMethodReferenceExpression)parent).getQualifierExpression()) != null) {
                parent.replace((PsiElement)qualifierExpression);
            }
        }
    }
}

