/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import java.util.ArrayList;

public class DupInstruction
extends Instruction {
    private final int myValueCount;
    private final int myDuplicationCount;

    public DupInstruction() {
        this(1, 1);
    }

    public DupInstruction(int valueCount, int duplicationCount) {
        this.myValueCount = valueCount;
        this.myDuplicationCount = duplicationCount;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState memState, InstructionVisitor visitor) {
        if (this.myDuplicationCount == 1 && this.myValueCount == 1) {
            memState.push(memState.peek());
        } else {
            ArrayList<DfaValue> values = new ArrayList<DfaValue>(this.myValueCount);
            for (int i = 0; i < this.myValueCount; ++i) {
                values.add(memState.pop());
            }
            for (int j = 0; j < this.myDuplicationCount + 1; ++j) {
                for (int i = values.size() - 1; i >= 0; --i) {
                    memState.push((DfaValue)values.get(i));
                }
            }
        }
        Instruction nextInstruction = runner.getInstruction(this.getIndex() + 1);
        return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, memState)};
    }

    public String toString() {
        return "DUP(" + this.myValueCount + " top stack values, " + this.myDuplicationCount + " times)";
    }
}

