/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodChainsSearchUtil {
    private MethodChainsSearchUtil() {
    }

    @Nullable
    public static PsiMethod getMethodWithMinNotPrimitiveParameters(@NotNull PsiMethod[] methods, Set<String> excludedParamsQNames) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/compiler/classFilesIndex/chainsSearch/MethodChainsSearchUtil", "getMethodWithMinNotPrimitiveParameters"));
        }
        PsiMethod minMethod = null;
        int minParametersCount = Integer.MAX_VALUE;
        for (PsiMethod method : methods) {
            PsiParameterList parameterList = method.getParameterList();
            boolean doContinue = false;
            int parametersCount = parameterList.getParametersCount();
            for (PsiParameter p : parameterList.getParameters()) {
                if (p.getType() instanceof PsiPrimitiveType) continue;
                if (excludedParamsQNames.contains(p.getType().getCanonicalText())) {
                    doContinue = true;
                    break;
                }
                ++parametersCount;
            }
            if (doContinue || parametersCount >= minParametersCount) continue;
            if (parametersCount == 0) {
                return method;
            }
            minParametersCount = parametersCount;
            minMethod = method;
        }
        return minMethod;
    }

    public static boolean checkParametersForTypesQNames(PsiMethod[] psiMethods, Set<String> excludedTypesQNames) {
        if (psiMethods.length == 0) {
            return true;
        }
        for (PsiMethod method : psiMethods) {
            boolean hasTargetInParams = false;
            for (PsiParameter param : method.getParameterList().getParameters()) {
                String paramType = param.getType().getCanonicalText();
                if (!excludedTypesQNames.contains(paramType)) continue;
                hasTargetInParams = true;
                break;
            }
            if (hasTargetInParams) continue;
            return true;
        }
        return false;
    }

    public static <T> HashSet<T> joinToHashSet(Collection<T> collection, T ... items) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(collection);
        Collections.addAll(result, items);
        return result;
    }
}

