/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.HashMap;
import java.util.Map;

@State(name="ValidationConfiguration", storages={@Storage(value="validation.xml")})
public class ValidationConfiguration
implements PersistentStateComponent<ValidationConfiguration> {
    public boolean VALIDATE_ON_BUILD = false;
    public Map<String, Boolean> VALIDATORS = new HashMap<String, Boolean>();

    public static boolean shouldValidate(Compiler validator, CompileContext context) {
        ValidationConfiguration configuration = ValidationConfiguration.getInstance(context.getProject());
        return configuration.VALIDATE_ON_BUILD && configuration.isSelected(validator);
    }

    public boolean isSelected(Compiler validator) {
        return this.isSelected(validator.getDescription());
    }

    public boolean isSelected(String validatorDescription) {
        Boolean selected = this.VALIDATORS.get(validatorDescription);
        return selected == null || selected != false;
    }

    public void setSelected(Compiler validator, boolean selected) {
        this.setSelected(validator.getDescription(), selected);
    }

    public void setSelected(String validatorDescription, boolean selected) {
        this.VALIDATORS.put(validatorDescription, selected);
    }

    public static ValidationConfiguration getInstance(Project project2) {
        return (ValidationConfiguration)ServiceManager.getService((Project)project2, ValidationConfiguration.class);
    }

    public static ExcludesConfiguration getExcludedEntriesConfiguration(Project project2) {
        return (ExcludesConfiguration)ServiceManager.getService((Project)project2, ExcludedFromValidationConfiguration.class);
    }

    public ValidationConfiguration getState() {
        return this;
    }

    public void loadState(ValidationConfiguration state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @State(name="ExcludeFromValidation", storages={@Storage(value="excludeFromValidation.xml")})
    public static class ExcludedFromValidationConfiguration
    extends ExcludedEntriesConfiguration {
    }
}

