/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server.impl;

import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.CompileServerPlugin;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class BuildProcessClasspathManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.impl.BuildProcessClasspathManager");
    private List<String> myCompileServerPluginsClasspath;

    public List<String> getBuildProcessPluginsClasspath(Project project2) {
        List<String> staticClasspath = this.getStaticClasspath();
        List<String> dynamicClasspath = BuildProcessClasspathManager.getDynamicClasspath(project2);
        if (dynamicClasspath.isEmpty()) {
            return staticClasspath;
        }
        dynamicClasspath.addAll(staticClasspath);
        return dynamicClasspath;
    }

    private List<String> getStaticClasspath() {
        if (this.myCompileServerPluginsClasspath == null) {
            this.myCompileServerPluginsClasspath = BuildProcessClasspathManager.computeCompileServerPluginsClasspath();
        }
        return this.myCompileServerPluginsClasspath;
    }

    private static List<String> computeCompileServerPluginsClasspath() {
        ArrayList classpath = ContainerUtil.newArrayList();
        for (CompileServerPlugin serverPlugin : (CompileServerPlugin[])CompileServerPlugin.EP_NAME.getExtensions()) {
            PluginId pluginId = serverPlugin.getPluginDescriptor().getPluginId();
            IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
            LOG.assertTrue(plugin != null, (Object)pluginId);
            File baseFile = plugin.getPath();
            if (baseFile.isFile()) {
                classpath.add(baseFile.getPath());
                continue;
            }
            if (!baseFile.isDirectory()) continue;
            for (String relativePath : StringUtil.split((String)serverPlugin.getClasspath(), (String)";")) {
                File dir;
                File jarFile = new File(new File(baseFile, "lib"), relativePath);
                File classesDir = new File(baseFile, "classes");
                if (jarFile.exists()) {
                    classpath.add(jarFile.getPath());
                    continue;
                }
                if (classesDir.isDirectory()) {
                    classpath.add(classesDir.getPath());
                    continue;
                }
                String moduleName = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)relativePath));
                File baseOutputDir = baseFile.getParentFile();
                if (baseOutputDir.getName().equals("test")) {
                    baseOutputDir = new File(baseOutputDir.getParentFile(), "production");
                }
                if ((dir = new File(baseOutputDir, moduleName)).exists()) {
                    classpath.add(dir.getPath());
                    continue;
                }
                File pluginDir = BuildProcessClasspathManager.getPluginDir(plugin);
                if (pluginDir != null) {
                    File libraryFile = new File(pluginDir, "lib" + File.separator + PathUtil.getFileName((String)relativePath));
                    if (libraryFile.exists()) {
                        classpath.add(libraryFile.getPath());
                        continue;
                    }
                    LOG.error("Cannot add " + relativePath + " from plugin '" + plugin.getName() + "' to external compiler classpath: " + "library " + libraryFile.getAbsolutePath() + " not found");
                    continue;
                }
                LOG.error("Cannot add " + relativePath + " from plugin '" + plugin.getName() + "' to external compiler classpath: home directory of plugin not found");
            }
        }
        return classpath;
    }

    @Nullable
    private static File getPluginDir(IdeaPluginDescriptor plugin) {
        File extraDirFile;
        String pluginDirName = StringUtil.getShortName((String)plugin.getPluginId().getIdString());
        String extraDir = System.getProperty("idea.external.build.development.plugins.dir");
        if (extraDir != null && (extraDirFile = new File(extraDir, pluginDirName)).isDirectory()) {
            return extraDirFile;
        }
        File pluginHome = PluginPathManager.getPluginHome(pluginDirName);
        if (!pluginHome.isDirectory() && StringUtil.isCapitalized((String)pluginDirName)) {
            pluginHome = PluginPathManager.getPluginHome(StringUtil.decapitalize((String)pluginDirName));
        }
        return pluginHome.isDirectory() ? pluginHome : null;
    }

    private static List<String> getDynamicClasspath(Project project2) {
        ArrayList classpath = ContainerUtil.newArrayList();
        for (BuildProcessParametersProvider provider : (BuildProcessParametersProvider[])project2.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            classpath.addAll(provider.getClassPath());
        }
        return classpath;
    }

    public static List<String> getLauncherClasspath(Project project2) {
        ArrayList classpath = ContainerUtil.newArrayList();
        for (BuildProcessParametersProvider provider : (BuildProcessParametersProvider[])project2.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            classpath.addAll(provider.getLauncherClassPath());
        }
        return classpath;
    }
}

