/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.TypeMarker;
import com.intellij.util.containers.UtilKt;
import java.io.DataOutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a \u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0012"}, d2={"isAllWhitespace", "", "obj", "Lorg/jdom/Content;", "output", "", "doc", "Lorg/jdom/Document;", "out", "Ljava/io/DataOutputStream;", "printAttributes", "attributes", "", "Lorg/jdom/Attribute;", "printElement", "element", "Lorg/jdom/Element;", "writeElement", "configuration-store-impl"})
public final class BinaryXmlOutputterKt {
    /*
     * WARNING - void declaration
     */
    public static final void output(@NotNull Document doc, @NotNull DataOutputStream out) {
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        List content = doc.getContent();
        int size = content.size();
        int n = 0;
        int n2 = size - 1;
        if (n <= n2) {
            while (true) {
                void i;
                Content obj;
                Content content2;
                if ((content2 = (obj = (Content)content.get((int)i))) instanceof Element) {
                    Element element = doc.getRootElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"doc.rootElement");
                    BinaryXmlOutputterKt.printElement(out, element);
                }
                if (i == n2) break;
                ++i;
            }
        }
        out.flush();
    }

    public static final void writeElement(@NotNull Element element, @NotNull DataOutputStream out) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        BinaryXmlOutputterKt.printElement(out, element);
        out.flush();
    }

    private static final void printElement(DataOutputStream out, Element element) {
        out.writeByte(TypeMarker.ELEMENT.ordinal());
        out.writeUTF(element.getName());
        List content = element.getContent();
        BinaryXmlOutputterKt.printAttributes(out, element.getAttributes());
        for (Content item : content) {
            if (item instanceof Element) {
                BinaryXmlOutputterKt.printElement(out, (Element)item);
                continue;
            }
            if (item instanceof Text) {
                if (BinaryXmlOutputterKt.isAllWhitespace(item)) continue;
                out.writeByte(TypeMarker.TEXT.ordinal());
                out.writeUTF(((Text)item).getText());
                continue;
            }
            if (!(item instanceof CDATA)) continue;
            out.writeByte(TypeMarker.CDATA.ordinal());
            out.writeUTF(((CDATA)item).getText());
        }
        out.writeByte(TypeMarker.ELEMENT_END.ordinal());
    }

    private static final void printAttributes(DataOutputStream out, List<? extends Attribute> attributes) {
        if (UtilKt.isNullOrEmpty(attributes)) {
            int n;
            List<? extends Attribute> list = attributes;
            int n2 = n = list != null ? list.size() : 0;
            if (n > 255) {
                throw (Throwable)new UnsupportedOperationException("attributes size > 255");
            }
            out.writeByte(n);
            return;
        }
        List<? extends Attribute> list = attributes;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (Attribute attribute : list) {
            out.writeUTF(attribute.getName());
            out.writeUTF(attribute.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isAllWhitespace(Content obj) {
        Object object;
        Content content = obj;
        if (!(content instanceof Text)) {
            content = null;
        }
        if ((object = (Text)content) == null || (object = object.getText()) == null) {
            return false;
        }
        Object str = object;
        int n = 0;
        int n2 = ((String)str).length() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (!Verifier.isXMLWhitespace((char)((String)str).charAt((int)i))) {
                    return false;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return true;
    }
}

