/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.PopFrameAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;

public class AddSteppingFilterAction
extends DebuggerAction {
    public void actionPerformed(final AnActionEvent e) {
        final DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        DebugProcessImpl process = debuggerContext.getDebugProcess();
        if (process == null) {
            return;
        }
        final StackFrameProxyImpl proxy = PopFrameAction.getStackFrameProxy(e);
        process.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() throws Exception {
                final String name = AddSteppingFilterAction.getClassName(proxy != null ? proxy : debuggerContext.getFrameProxy());
                if (name == null) {
                    return;
                }
                final Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String filter = Messages.showInputDialog((Project)project2, (String)"", (String)"Add Stepping Filter", null, (String)name, null);
                        if (filter != null) {
                            ClassFilter[] newFilters = (ClassFilter[])ArrayUtil.append((Object[])DebuggerSettings.getInstance().getSteppingFilters(), (Object)new ClassFilter(filter));
                            DebuggerSettings.getInstance().setSteppingFilters(newFilters);
                        }
                    }
                });
            }
        });
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(PopFrameAction.getStackFrameProxy(e) != null);
    }

    private static String getClassName(StackFrameProxyImpl stackFrameProxy) {
        if (stackFrameProxy != null) {
            try {
                ReferenceType type;
                Location location = stackFrameProxy.location();
                if (location != null && (type = location.declaringType()) != null) {
                    return type.name();
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return null;
    }
}

