/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;

public class FreezeThreadAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        DebuggerTreeNodeImpl[] selectedNode = FreezeThreadAction.getSelectedNodes(e.getDataContext());
        if (selectedNode == null) {
            return;
        }
        DebuggerContextImpl debuggerContext = FreezeThreadAction.getDebuggerContext(e.getDataContext());
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        for (final DebuggerTreeNodeImpl debuggerTreeNode : selectedNode) {
            ThreadDescriptorImpl threadDescriptor = (ThreadDescriptorImpl)debuggerTreeNode.getDescriptor();
            final ThreadReferenceProxyImpl thread = threadDescriptor.getThreadReference();
            if (threadDescriptor.isFrozen()) continue;
            debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    debugProcess.createFreezeThreadCommand(thread).run();
                    debuggerTreeNode.calcValue();
                }
            });
        }
    }

    public void update(AnActionEvent e) {
        DebuggerTreeNodeImpl[] selectedNode = FreezeThreadAction.getSelectedNodes(e.getDataContext());
        if (selectedNode == null) {
            return;
        }
        DebugProcessImpl debugProcess = FreezeThreadAction.getDebuggerContext(e.getDataContext()).getDebugProcess();
        boolean visible = false;
        if (debugProcess != null) {
            visible = true;
            for (DebuggerTreeNodeImpl aSelectedNode : selectedNode) {
                NodeDescriptorImpl threadDescriptor = aSelectedNode.getDescriptor();
                if (threadDescriptor instanceof ThreadDescriptorImpl && !((ThreadDescriptorImpl)threadDescriptor).isSuspended()) continue;
                visible = false;
                break;
            }
        }
        e.getPresentation().setVisible(visible);
    }
}

