/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.Range;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaSmartStepTarget
extends SmartStepTarget {
    private final PsiLambdaExpression myLambda;
    private final int myOrdinal;

    public LambdaSmartStepTarget(@NotNull PsiLambdaExpression lambda2, @Nullable String label, @Nullable PsiElement highlightElement, int ordinal, Range<Integer> lines) {
        if (lambda2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/intellij/debugger/actions/LambdaSmartStepTarget", "<init>"));
        }
        super(label, highlightElement, true, lines);
        this.myLambda = lambda2;
        this.myOrdinal = ordinal;
    }

    public PsiLambdaExpression getLambda() {
        return this.myLambda;
    }

    public int getOrdinal() {
        return this.myOrdinal;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myLambda.getIcon(0);
    }

    @Override
    @NotNull
    public String getPresentation() {
        String typeText = PsiFormatUtil.formatType((PsiType)this.myLambda.getType(), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        String label = this.getLabel();
        String string = label != null ? label + typeText : typeText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/LambdaSmartStepTarget", "getPresentation"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaSmartStepTarget that = (LambdaSmartStepTarget)o;
        if (this.myOrdinal != that.myOrdinal) {
            return false;
        }
        return this.myLambda.equals(that.myLambda);
    }

    public int hashCode() {
        int result = this.myLambda.hashCode();
        result = 31 * result + this.myOrdinal;
        return result;
    }
}

