/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SmartStepTarget {
    private final PsiElement myHighlightElement;
    private final String myLabel;
    private final boolean myNeedBreakpointRequest;
    private Range<Integer> myExpressionLines;

    protected SmartStepTarget(@Nullable String label, @Nullable PsiElement highlightElement, boolean needBreakpointRequest, Range<Integer> expressionLines) {
        this.myHighlightElement = highlightElement;
        this.myLabel = label;
        this.myNeedBreakpointRequest = needBreakpointRequest;
        this.myExpressionLines = expressionLines;
    }

    @Nullable
    public PsiElement getHighlightElement() {
        return this.myHighlightElement;
    }

    @Nullable
    public String getLabel() {
        return this.myLabel;
    }

    public boolean needsBreakpointRequest() {
        return this.myNeedBreakpointRequest;
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.myExpressionLines;
    }

    public void setCallingExpressionLines(Range<Integer> expressionLines) {
        this.myExpressionLines = expressionLines;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getPresentation() {
        String string = StringUtil.notNullize((String)this.getLabel());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/SmartStepTarget", "getPresentation"));
        }
        return string;
    }
}

