/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicStepMethodFilter
implements NamedMethodFilter {
    private static final Logger LOG = Logger.getInstance(BasicStepMethodFilter.class);
    @NotNull
    protected final JVMName myDeclaringClassName;
    @NotNull
    private final String myTargetMethodName;
    @Nullable
    protected final JVMName myTargetMethodSignature;
    private final Range<Integer> myCallingExpressionLines;

    public BasicStepMethodFilter(@NotNull PsiMethod psiMethod, Range<Integer> callingExpressionLines) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/debugger/engine/BasicStepMethodFilter", "<init>"));
        }
        this(JVMNameUtil.getJVMQualifiedName(psiMethod.getContainingClass()), JVMNameUtil.getJVMMethodName(psiMethod), JVMNameUtil.getJVMSignature(psiMethod), callingExpressionLines);
    }

    protected BasicStepMethodFilter(@NotNull JVMName declaringClassName, @NotNull String targetMethodName, @Nullable JVMName targetMethodSignature, Range<Integer> callingExpressionLines) {
        if (declaringClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringClassName", "com/intellij/debugger/engine/BasicStepMethodFilter", "<init>"));
        }
        if (targetMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetMethodName", "com/intellij/debugger/engine/BasicStepMethodFilter", "<init>"));
        }
        this.myDeclaringClassName = declaringClassName;
        this.myTargetMethodName = targetMethodName;
        this.myTargetMethodSignature = targetMethodSignature;
        this.myCallingExpressionLines = callingExpressionLines;
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.myTargetMethodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/BasicStepMethodFilter", "getMethodName"));
        }
        return string;
    }

    @Override
    public boolean locationMatches(final DebugProcessImpl process, final Location location) throws EvaluateException {
        Method method = location.method();
        boolean lambdaMatched = false;
        String name = method.name();
        if (!this.myTargetMethodName.equals(name)) {
            if (LambdaMethodFilter.isLambdaName(name)) {
                lambdaMatched = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        PsiElement psiMethod = DebuggerUtilsEx.getContainingMethod(process.getPositionManager().getSourcePosition(location));
                        if (psiMethod instanceof PsiLambdaExpression) {
                            PsiType type = ((PsiLambdaExpression)psiMethod).getFunctionalInterfaceType();
                            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
                            if (type != null && interfaceMethod != null && BasicStepMethodFilter.this.myTargetMethodName.equals(interfaceMethod.getName())) {
                                try {
                                    return type.getCanonicalText().equals(BasicStepMethodFilter.this.myDeclaringClassName.getName(process).replace('$', '.'));
                                }
                                catch (EvaluateException e) {
                                    LOG.info((Throwable)e);
                                }
                            }
                        }
                        return false;
                    }
                });
            }
            if (!lambdaMatched) {
                return false;
            }
        }
        if (this.myTargetMethodSignature != null && !BasicStepMethodFilter.signatureMatches(method, this.myTargetMethodSignature.getName(process))) {
            return false;
        }
        return lambdaMatched || DebuggerUtilsEx.isAssignableFrom(this.myDeclaringClassName.getName(process), location.declaringType());
    }

    private static boolean signatureMatches(Method method, String expectedSignature) throws EvaluateException {
        if (expectedSignature.equals(method.signature())) {
            return true;
        }
        for (Method candidate : method.declaringType().methodsByName(method.name())) {
            if (candidate == method || !candidate.isBridge() || !expectedSignature.equals(candidate.signature())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }
}

