/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VirtualMachine;

public class DefaultSyntheticProvider
implements SyntheticTypeComponentProvider {
    public boolean isSynthetic(TypeComponent typeComponent) {
        String name = typeComponent.name();
        if (LambdaMethodFilter.isLambdaName(name)) {
            return false;
        }
        if (DebuggerUtilsEx.isLambdaClassName(typeComponent.declaringType().name())) {
            return true;
        }
        VirtualMachine machine = typeComponent.virtualMachine();
        if (machine != null && machine.canGetSyntheticAttribute()) {
            return typeComponent.isSynthetic();
        }
        return name.contains("$");
    }
}

