/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class BoxingEvaluator
implements Evaluator {
    private final Evaluator myOperand;

    public BoxingEvaluator(Evaluator operand) {
        this.myOperand = new DisableGC(operand);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object result = this.myOperand.evaluate(context);
        if (result == null || result instanceof ObjectReference) {
            return result;
        }
        if (result instanceof BooleanValue) {
            return BoxingEvaluator.convertToWrapper(context, (BooleanValue)result, "java.lang.Boolean");
        }
        if (result instanceof ByteValue) {
            return BoxingEvaluator.convertToWrapper(context, (ByteValue)result, "java.lang.Byte");
        }
        if (result instanceof CharValue) {
            return BoxingEvaluator.convertToWrapper(context, (CharValue)result, "java.lang.Character");
        }
        if (result instanceof ShortValue) {
            return BoxingEvaluator.convertToWrapper(context, (ShortValue)result, "java.lang.Short");
        }
        if (result instanceof IntegerValue) {
            return BoxingEvaluator.convertToWrapper(context, (IntegerValue)result, "java.lang.Integer");
        }
        if (result instanceof LongValue) {
            return BoxingEvaluator.convertToWrapper(context, (LongValue)result, "java.lang.Long");
        }
        if (result instanceof FloatValue) {
            return BoxingEvaluator.convertToWrapper(context, (FloatValue)result, "java.lang.Float");
        }
        if (result instanceof DoubleValue) {
            return BoxingEvaluator.convertToWrapper(context, (DoubleValue)result, "java.lang.Double");
        }
        throw new EvaluateException("Cannot perform boxing conversion for a value of type " + ((Value)result).type().name());
    }

    @Override
    @Nullable
    public Modifier getModifier() {
        return null;
    }

    private static Value convertToWrapper(EvaluationContextImpl context, PrimitiveValue value, String wrapperTypeName) throws EvaluateException {
        String methodSignature;
        DebugProcessImpl process = context.getDebugProcess();
        ClassType wrapperClass = (ClassType)process.findClass(context, wrapperTypeName, null);
        List<Method> methods = wrapperClass.methodsByName("valueOf", methodSignature = "(" + JVMNameUtil.getPrimitiveSignature(value.type().name()) + ")L" + wrapperTypeName.replace('.', '/') + ";");
        if (methods.size() == 0) {
            methods = wrapperClass.methodsByName("<init>", methodSignature);
        }
        if (methods.size() == 0) {
            throw new EvaluateException("Cannot construct wrapper object for value of type " + value.type() + ": Unable to find either valueOf() or constructor method");
        }
        return process.invokeMethod((EvaluationContext)context, wrapperClass, methods.get(0), Collections.singletonList(value));
    }
}

