/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.AbstractToolWindowManager;
import com.intellij.designer.DesignerEditor;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.DesignerEditorState;
import com.intellij.designer.DesignerToolWindowContent;
import com.intellij.designer.DesignerToolWindowManager;
import com.intellij.designer.LightFillLayout;
import com.intellij.designer.ModuleProvider;
import com.intellij.designer.PaletteToolWindowContent;
import com.intellij.designer.actions.AbstractComboBoxAction;
import com.intellij.designer.actions.CommonEditActionsProvider;
import com.intellij.designer.actions.DesignerActionPanel;
import com.intellij.designer.componentTree.TreeComponentDecorator;
import com.intellij.designer.componentTree.TreeEditableArea;
import com.intellij.designer.designSurface.CaptionPanel;
import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.ComponentEditableArea;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.GlassLayer;
import com.intellij.designer.designSurface.InplaceEditingLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.QuickFixManager;
import com.intellij.designer.designSurface.ZoomType;
import com.intellij.designer.designSurface.tools.ComponentCreationFactory;
import com.intellij.designer.designSurface.tools.ComponentPasteFactory;
import com.intellij.designer.designSurface.tools.CreationTool;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.MarqueeTracker;
import com.intellij.designer.designSurface.tools.PasteTool;
import com.intellij.designer.designSurface.tools.SelectionTool;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.model.FindComponentVisitor;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadPropertyContext;
import com.intellij.designer.model.WrapInProvider;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.palette.PaletteToolWindowManager;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyTableTab;
import com.intellij.designer.propertyTable.TablePanelActionPolicy;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignerEditorPanel
extends JPanel
implements DesignerEditorPanelFacade,
DataProvider,
ModuleProvider,
RadPropertyContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.designer.designSurface.DesignerEditorPanel");
    protected static final Integer LAYER_COMPONENT = JLayeredPane.DEFAULT_LAYER;
    protected static final Integer LAYER_DECORATION = JLayeredPane.POPUP_LAYER;
    protected static final Integer LAYER_FEEDBACK = JLayeredPane.DRAG_LAYER;
    protected static final Integer LAYER_GLASS = LAYER_FEEDBACK + 100;
    protected static final Integer LAYER_INPLACE_EDITING = LAYER_GLASS + 100;
    private static final Integer LAYER_PROGRESS = LAYER_INPLACE_EDITING + 100;
    private static final String DESIGNER_CARD = "designer";
    private static final String ERROR_CARD = "error";
    private static final String ERROR_STACK_CARD = "stack";
    private static final String ERROR_NO_STACK_CARD = "no_stack";
    @NotNull
    private final DesignerEditor myEditor;
    private final Project myProject;
    private Module myModule;
    protected final VirtualFile myFile;
    private final CardLayout myLayout;
    private final ThreeComponentsSplitter myContentSplitter;
    private final JPanel myPanel;
    private JComponent myDesignerCard;
    protected DesignerActionPanel myActionPanel;
    protected CaptionPanel myHorizontalCaption;
    protected CaptionPanel myVerticalCaption;
    protected JScrollPane myScrollPane;
    protected JLayeredPane myLayeredPane;
    protected GlassLayer myGlassLayer;
    private DecorationLayer myDecorationLayer;
    private FeedbackLayer myFeedbackLayer;
    private InplaceEditingLayer myInplaceEditingLayer;
    protected ToolProvider myToolProvider;
    protected EditableArea mySurfaceArea;
    protected RadComponent myRootComponent;
    protected QuickFixManager myQuickFixManager;
    private PaletteItem myActivePaletteItem;
    private List<?> myExpandedComponents;
    private final Map<String, Property> mySelectionPropertyMap;
    private int[][] myExpandedState;
    private int[][] mySelectionState;
    private final Map<String, int[][]> mySourceSelectionState;
    private FixableMessageAction myWarnAction;
    private JPanel myErrorPanel;
    protected JPanel myErrorMessages;
    private JPanel myErrorStackPanel;
    private CardLayout myErrorStackLayout;
    private JTextArea myErrorStack;
    private JPanel myProgressPanel;
    private AsyncProcessIcon myProgressIcon;
    private JLabel myProgressMessage;
    protected String myLastExecuteCommand;

    public DesignerEditorPanel(@NotNull DesignerEditor editor, @NotNull Project project2, Module module2, @NotNull VirtualFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/designer/designSurface/DesignerEditorPanel", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/designer/designSurface/DesignerEditorPanel", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/designer/designSurface/DesignerEditorPanel", "<init>"));
        }
        this.myLayout = new CardLayout();
        this.myContentSplitter = new ThreeComponentsSplitter();
        this.myPanel = new JPanel(this.myLayout);
        this.mySelectionPropertyMap = new HashMap<String, Property>();
        this.mySourceSelectionState = new FixedHashMap<String, int[][]>(16);
        this.myEditor = editor;
        this.myProject = project2;
        this.myModule = module2;
        this.myFile = file2;
        this.initUI();
        this.myToolProvider.loadDefaultTool();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.myContentSplitter.setDividerWidth(0);
        this.myContentSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.add((Component)this.myContentSplitter, "Center");
        this.createDesignerCard();
        this.createErrorCard();
        this.createProgressPanel();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DesignerEditorPanel designer = DesignerEditorPanel.this;
                DesignerEditorPanel.this.getDesignerWindowManager().bind(designer);
                DesignerEditorPanel.this.getPaletteWindowManager().bind(designer);
            }
        });
    }

    private void createDesignerCard() {
        JPanel panel = new JPanel(new LightFillLayout());
        this.myContentSplitter.setInnerComponent((JComponent)panel);
        this.myLayeredPane = new MyLayeredPane();
        this.mySurfaceArea = this.createEditableArea();
        this.myToolProvider = this.createToolProvider();
        this.myGlassLayer = this.createGlassLayer(this.myToolProvider, this.mySurfaceArea);
        this.myLayeredPane.add((Component)this.myGlassLayer, LAYER_GLASS);
        this.myDecorationLayer = this.createDecorationLayer();
        this.myLayeredPane.add((Component)this.myDecorationLayer, LAYER_DECORATION);
        this.myFeedbackLayer = this.createFeedbackLayer();
        this.myLayeredPane.add((Component)this.myFeedbackLayer, LAYER_FEEDBACK);
        this.myInplaceEditingLayer = this.createInplaceEditingLayer();
        this.myLayeredPane.add((Component)this.myInplaceEditingLayer, LAYER_INPLACE_EDITING);
        this.myScrollPane = this.createScrollPane(this.myLayeredPane);
        this.myQuickFixManager = new QuickFixManager(this, this.myGlassLayer, this.myScrollPane.getViewport());
        this.myActionPanel = this.createActionPanel();
        this.myWarnAction = new FixableMessageAction();
        panel.add(this.myActionPanel.getToolbarComponent());
        panel.add(this.myPanel);
        this.myDesignerCard = this.createDesignerCardPanel();
        this.myPanel.add((Component)this.myDesignerCard, DESIGNER_CARD);
        this.mySurfaceArea.addSelectionListener(new ComponentSelectionListener(){

            @Override
            public void selectionChanged(EditableArea area) {
                DesignerEditorPanel.this.storeSourceSelectionState();
            }
        });
    }

    protected JComponent createDesignerCardPanel() {
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 3;
        this.myVerticalCaption = this.createCaptionPanel(false);
        content.add((Component)((Object)this.myVerticalCaption), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.myHorizontalCaption = this.createCaptionPanel(true);
        content.add((Component)((Object)this.myHorizontalCaption), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        content.add((Component)this.myScrollPane, gbc);
        this.myHorizontalCaption.attachToScrollPane(this.myScrollPane);
        this.myVerticalCaption.attachToScrollPane(this.myScrollPane);
        return content;
    }

    @Override
    public final ThreeComponentsSplitter getContentSplitter() {
        return this.myContentSplitter;
    }

    protected EditableArea createEditableArea() {
        return new DesignerEditableArea();
    }

    protected ToolProvider createToolProvider() {
        return new DesignerToolProvider();
    }

    protected GlassLayer createGlassLayer(ToolProvider provider, EditableArea area) {
        return new GlassLayer(provider, area);
    }

    protected DecorationLayer createDecorationLayer() {
        return new DecorationLayer(this, this.mySurfaceArea);
    }

    protected FeedbackLayer createFeedbackLayer() {
        return new FeedbackLayer(this);
    }

    protected InplaceEditingLayer createInplaceEditingLayer() {
        return new InplaceEditingLayer(this);
    }

    protected CaptionPanel createCaptionPanel(boolean horizontal) {
        return new CaptionPanel(this, horizontal, true);
    }

    protected JScrollPane createScrollPane(@NotNull JLayeredPane content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/designer/designSurface/DesignerEditorPanel", "createScrollPane"));
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)content);
        scrollPane.setBackground((Color)new JBColor(Color.WHITE, UIUtil.getListBackground()));
        return scrollPane;
    }

    protected DesignerActionPanel createActionPanel() {
        return new DesignerActionPanel(this, this.myGlassLayer);
    }

    @Nullable
    public final PaletteItem getActivePaletteItem() {
        return this.myActivePaletteItem;
    }

    public final void activatePaletteItem(@Nullable PaletteItem paletteItem) {
        this.myActivePaletteItem = paletteItem;
        if (paletteItem != null) {
            this.myToolProvider.setActiveTool(new CreationTool(true, this.createCreationFactory(paletteItem)));
        } else if (this.myToolProvider.getActiveTool() instanceof CreationTool) {
            this.myToolProvider.loadDefaultTool();
        }
    }

    protected final void showDesignerCard() {
        this.myErrorMessages.removeAll();
        this.myErrorStack.setText(null);
        this.myLayeredPane.revalidate();
        if (this.myHorizontalCaption != null) {
            this.myHorizontalCaption.update();
        }
        if (this.myVerticalCaption != null) {
            this.myVerticalCaption.update();
        }
        this.myLayout.show(this.myPanel, DESIGNER_CARD);
    }

    private void createErrorCard() {
        this.myErrorPanel = new JPanel(new BorderLayout());
        this.myErrorMessages = new JPanel((LayoutManager)new VerticalFlowLayout(0, 10, 5, true, false));
        this.myErrorPanel.add((Component)this.myErrorMessages, "First");
        this.myErrorStack = new JTextArea(50, 20);
        this.myErrorStack.setEditable(false);
        this.myErrorStackLayout = new CardLayout();
        this.myErrorStackPanel = new JPanel(this.myErrorStackLayout);
        this.myErrorStackPanel.add((Component)new JLabel(), ERROR_NO_STACK_CARD);
        this.myErrorStackPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myErrorStack), ERROR_STACK_CARD);
        this.myErrorPanel.add((Component)this.myErrorStackPanel, "Center");
        this.myPanel.add((Component)this.myErrorPanel, ERROR_CARD);
    }

    public final void showError(@NotNull String message, @NotNull Throwable e) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/designer/designSurface/DesignerEditorPanel", "showError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/designer/designSurface/DesignerEditorPanel", "showError"));
        }
        if (this.isProjectClosed()) {
            return;
        }
        while (e instanceof InvocationTargetException && e.getCause() != null) {
            e = e.getCause();
        }
        ErrorInfo info = new ErrorInfo();
        info.myMessage = info.myDisplayMessage = message;
        info.myThrowable = e;
        this.configureError(info);
        if (info.myShowMessage) {
            this.showErrorPage(info);
        }
        if (info.myShowLog) {
            LOG.error((Object)LogMessageEx.createEvent(info.myDisplayMessage, info.myMessage + "\n" + ExceptionUtil.getThrowableText((Throwable)info.myThrowable), this.getErrorAttachments(info)));
        }
    }

    protected Attachment[] getErrorAttachments(ErrorInfo info) {
        return new Attachment[]{AttachmentFactory.createAttachment(this.myFile)};
    }

    protected abstract void configureError(@NotNull ErrorInfo var1);

    protected void showErrorPage(ErrorInfo info) {
        this.storeState();
        this.hideProgress();
        this.myRootComponent = null;
        this.myErrorMessages.removeAll();
        if (info.myShowStack) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            info.myThrowable.printStackTrace(new PrintStream(stream));
            this.myErrorStack.setText(stream.toString());
            this.myErrorStackLayout.show(this.myErrorStackPanel, ERROR_STACK_CARD);
        } else {
            this.myErrorStack.setText(null);
            this.myErrorStackLayout.show(this.myErrorStackPanel, ERROR_NO_STACK_CARD);
        }
        this.addErrorMessage(new FixableMessageInfo(true, info.myDisplayMessage, "", "", null, null), Messages.getErrorIcon());
        for (FixableMessageInfo message : info.myMessages) {
            this.addErrorMessage(message, message.myErrorIcon ? Messages.getErrorIcon() : Messages.getWarningIcon());
        }
        this.myErrorPanel.revalidate();
        this.myLayout.show(this.myPanel, ERROR_CARD);
        this.getDesignerToolWindow().refresh(true);
        this.repaint();
    }

    protected void addErrorMessage(final FixableMessageInfo message, Icon icon) {
        HyperlinkLabel warnLabel;
        if (message.myLinkText.length() > 0 || message.myAfterLinkText.length() > 0) {
            warnLabel = new HyperlinkLabel();
            warnLabel.setOpaque(false);
            warnLabel.setHyperlinkText(message.myBeforeLinkText, message.myLinkText, message.myAfterLinkText);
            warnLabel.setIcon(icon);
            if (message.myQuickFix != null) {
                warnLabel.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            message.myQuickFix.run();
                        }
                    }
                });
            }
            this.myErrorMessages.add((Component)warnLabel);
        } else {
            warnLabel = new JBLabel();
            warnLabel.setOpaque(false);
            warnLabel.setText("<html><body>" + message.myBeforeLinkText.replace("\n", "<br>") + "</body></html>");
            warnLabel.setIcon(icon);
            this.myErrorMessages.add((Component)warnLabel);
        }
        if (message.myAdditionalFixes != null && message.myAdditionalFixes.size() > 0) {
            JPanel fixesPanel = new JPanel(new FlowLayout(0, 5, 0));
            fixesPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)3, (int)0, (int)10, (int)0));
            fixesPanel.setOpaque(false);
            fixesPanel.add(Box.createHorizontalStrut(icon.getIconWidth()));
            for (Pair<String, Runnable> pair : message.myAdditionalFixes) {
                HyperlinkLabel fixLabel = new HyperlinkLabel();
                fixLabel.setOpaque(false);
                fixLabel.setHyperlinkText((String)pair.getFirst());
                final Runnable fix = (Runnable)pair.getSecond();
                fixLabel.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            fix.run();
                        }
                    }
                });
                fixesPanel.add((Component)fixLabel);
            }
            this.myErrorMessages.add(fixesPanel);
        }
    }

    protected final void showWarnMessages(@Nullable List<FixableMessageInfo> messages) {
        if (messages == null) {
            this.myWarnAction.hide();
        } else {
            this.myWarnAction.show(messages);
        }
    }

    private void createProgressPanel() {
        this.myProgressIcon = new AsyncProcessIcon("Designer progress");
        this.myProgressMessage = new JLabel();
        JPanel progressBlock = new JPanel();
        progressBlock.add((Component)this.myProgressIcon);
        progressBlock.add(this.myProgressMessage);
        progressBlock.setBorder((Border)IdeBorderFactory.createRoundedBorder());
        this.myProgressPanel = new JPanel(new GridBagLayout());
        this.myProgressPanel.add((Component)progressBlock, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myProgressPanel.setOpaque(false);
    }

    protected final void showProgress(String message) {
        this.myProgressMessage.setText(message);
        if (this.myProgressPanel.getParent() == null) {
            this.myGlassLayer.setEnabled(false);
            this.myProgressIcon.resume();
            this.myLayeredPane.add((Component)this.myProgressPanel, LAYER_PROGRESS);
            this.myLayeredPane.repaint();
        }
    }

    protected final void hideProgress() {
        this.myGlassLayer.setEnabled(true);
        this.myProgressIcon.suspend();
        this.myLayeredPane.remove(this.myProgressPanel);
    }

    @Override
    @NotNull
    public final Module getModule() {
        if (this.myModule.isDisposed()) {
            this.myModule = this.findModule(this.myProject, this.myFile);
            if (this.myModule == null) {
                throw new IllegalArgumentException("No module for file " + this.myFile + " in project " + this.myProject);
            }
        }
        Module module2 = this.myModule;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/DesignerEditorPanel", "getModule"));
        }
        return module2;
    }

    @Nullable
    protected Module findModule(Project project2, VirtualFile file2) {
        return ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project2);
    }

    @NotNull
    public final DesignerEditor getEditor() {
        DesignerEditor designerEditor = this.myEditor;
        if (designerEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/DesignerEditorPanel", "getEditor"));
        }
        return designerEditor;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    public final Project getProject() {
        return this.myProject;
    }

    public final boolean isProjectClosed() {
        return this.myProject.isDisposed() || !this.myProject.isOpen();
    }

    public EditableArea getSurfaceArea() {
        return this.mySurfaceArea;
    }

    public ToolProvider getToolProvider() {
        return this.myToolProvider;
    }

    public DesignerActionPanel getActionPanel() {
        return this.myActionPanel;
    }

    public InplaceEditingLayer getInplaceEditingLayer() {
        return this.myInplaceEditingLayer;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDesignerCard.isVisible() ? this.myGlassLayer : this.myErrorPanel;
    }

    @Nullable
    public List<?> getExpandedComponents() {
        return this.myExpandedComponents;
    }

    public void setExpandedComponents(@Nullable List<?> expandedComponents) {
        this.myExpandedComponents = expandedComponents;
    }

    public Property getSelectionProperty(@Nullable String key) {
        return this.mySelectionPropertyMap.get(key);
    }

    public void setSelectionProperty(@Nullable String key, Property selectionProperty) {
        this.mySelectionPropertyMap.put(key, selectionProperty);
    }

    protected void storeState() {
        if (this.myRootComponent != null && this.myExpandedState == null && this.mySelectionState == null) {
            this.myExpandedState = new int[this.myExpandedComponents == null ? 0 : this.myExpandedComponents.size()][];
            for (int i = 0; i < this.myExpandedState.length; ++i) {
                IntArrayList path = new IntArrayList();
                DesignerEditorPanel.componentToPath((RadComponent)this.myExpandedComponents.get(i), path);
                this.myExpandedState[i] = path.toArray();
            }
            this.mySelectionState = this.getSelectionState();
            this.myExpandedComponents = null;
            InputTool tool = this.myToolProvider.getActiveTool();
            if (!(tool instanceof MarqueeTracker || tool instanceof CreationTool || tool instanceof PasteTool)) {
                this.myToolProvider.loadDefaultTool();
            }
        }
    }

    private void storeSourceSelectionState() {
        if (!CommonEditActionsProvider.isDeleting) {
            this.mySourceSelectionState.put(this.getEditorText(), this.getSelectionState());
        }
    }

    private int[][] getSelectionState() {
        return DesignerEditorPanel.getSelectionState(this.mySurfaceArea.getSelection());
    }

    protected static int[][] getSelectionState(List<RadComponent> selection) {
        int[][] selectionState = new int[selection.size()][];
        for (int i = 0; i < selectionState.length; ++i) {
            IntArrayList path = new IntArrayList();
            DesignerEditorPanel.componentToPath(selection.get(i), path);
            selectionState[i] = path.toArray();
        }
        return selectionState;
    }

    private static void componentToPath(RadComponent component, IntArrayList path) {
        RadComponent parent = component.getParent();
        if (parent != null) {
            path.add(0, parent.getChildren().indexOf(component));
            DesignerEditorPanel.componentToPath(parent, path);
        }
    }

    protected void restoreState() {
        DesignerToolWindowContent toolManager = this.getDesignerToolWindow();
        if (this.myExpandedState != null) {
            ArrayList<RadComponent> expanded = new ArrayList<RadComponent>();
            for (int[] path : this.myExpandedState) {
                DesignerEditorPanel.pathToComponent(expanded, this.myRootComponent, path, 0);
            }
            this.myExpandedComponents = expanded;
            toolManager.expandFromState();
            this.myExpandedState = null;
        }
        ArrayList<RadComponent> selection = new ArrayList<RadComponent>();
        int[][] selectionState = this.mySourceSelectionState.get(this.getEditorText());
        if (selectionState != null) {
            for (int[] path : selectionState) {
                DesignerEditorPanel.pathToComponent(selection, this.myRootComponent, path, 0);
            }
        }
        if (selection.isEmpty() && this.mySelectionState != null) {
            for (int[] path : this.mySelectionState) {
                DesignerEditorPanel.pathToComponent(selection, this.myRootComponent, path, 0);
            }
        }
        if (selection.isEmpty()) {
            toolManager.refresh(true);
        } else {
            this.mySurfaceArea.setSelection(selection);
        }
        this.mySelectionState = null;
    }

    protected static void pathToComponent(List<RadComponent> components, RadComponent component, int[] path, int index) {
        if (index == path.length) {
            components.add(component);
        } else {
            List<RadComponent> children2 = component.getChildren();
            int componentIndex = path[index];
            if (0 <= componentIndex && componentIndex < children2.size()) {
                DesignerEditorPanel.pathToComponent(components, children2.get(componentIndex), path, index + 1);
            }
        }
    }

    public abstract String getPlatformTarget();

    protected RadComponent findTarget(int x, int y, @Nullable ComponentTargetFilter filter) {
        if (this.myRootComponent != null) {
            FindComponentVisitor visitor = new FindComponentVisitor(this.myLayeredPane, filter, x, y);
            this.myRootComponent.accept(visitor, false);
            return visitor.getResult();
        }
        return null;
    }

    protected abstract ComponentDecorator getRootSelectionDecorator();

    @Nullable
    protected EditOperation processRootOperation(OperationContext context) {
        return null;
    }

    protected abstract boolean execute(ThrowableRunnable<Exception> var1, boolean var2);

    protected abstract void executeWithReparse(ThrowableRunnable<Exception> var1);

    protected abstract void execute(List<EditOperation> var1);

    public abstract List<PaletteGroup> getPaletteGroups();

    @NotNull
    public String getVersionLabel(@Nullable String version) {
        String string = StringUtil.notNullize((String)version);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/DesignerEditorPanel", "getVersionLabel"));
        }
        return string;
    }

    public boolean isDeprecated(@Nullable String deprecatedIn) {
        return !StringUtil.isEmpty((String)deprecatedIn);
    }

    protected InputTool createDefaultTool() {
        return new SelectionTool();
    }

    @NotNull
    protected abstract ComponentCreationFactory createCreationFactory(PaletteItem var1);

    @Nullable
    public abstract ComponentPasteFactory createPasteFactory(String var1);

    public abstract String getEditorText();

    public void activate() {
    }

    public void deactivate() {
    }

    @NotNull
    public DesignerEditorState createState() {
        DesignerEditorState designerEditorState = new DesignerEditorState(this.myFile, this.getZoom());
        if (designerEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/DesignerEditorPanel", "createState"));
        }
        return designerEditorState;
    }

    public boolean isEditorValid() {
        return this.myFile.isValid();
    }

    public Object getData(@NonNls String dataId) {
        return this.myActionPanel.getData(dataId);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myProgressIcon);
        this.getDesignerWindowManager().dispose(this);
        this.getPaletteWindowManager().dispose(this);
        Disposer.dispose((Disposable)this.myContentSplitter);
    }

    protected AbstractToolWindowManager getDesignerWindowManager() {
        return DesignerToolWindowManager.getInstance(this.myProject);
    }

    protected AbstractToolWindowManager getPaletteWindowManager() {
        return PaletteToolWindowManager.getInstance(this.myProject);
    }

    public DesignerToolWindowContent getDesignerToolWindow() {
        return DesignerToolWindowManager.getInstance(this);
    }

    protected PaletteToolWindowContent getPaletteToolWindow() {
        return PaletteToolWindowManager.getInstance(this);
    }

    @Nullable
    public WrapInProvider getWrapInProvider() {
        return null;
    }

    @Override
    @Nullable
    public RadComponent getRootComponent() {
        return this.myRootComponent;
    }

    public Object[] getTreeRoots() {
        Object[] objectArray;
        if (this.myRootComponent == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.myRootComponent;
        }
        return objectArray;
    }

    public abstract TreeComponentDecorator getTreeDecorator();

    public void handleTreeArea(TreeEditableArea treeArea) {
    }

    @NotNull
    public TablePanelActionPolicy getTablePanelActionPolicy() {
        TablePanelActionPolicy tablePanelActionPolicy = TablePanelActionPolicy.ALL;
        if (tablePanelActionPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/DesignerEditorPanel", "getTablePanelActionPolicy"));
        }
        return tablePanelActionPolicy;
    }

    @Nullable
    public PropertyTableTab[] getPropertyTableTabs() {
        return null;
    }

    public boolean isZoomSupported() {
        return false;
    }

    public void zoom(@NotNull ZoomType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/designer/designSurface/DesignerEditorPanel", "zoom"));
        }
    }

    public void setZoom(double zoom) {
    }

    public double getZoom() {
        return 1.0;
    }

    protected void viewZoomed() {
        this.myQuickFixManager.hideHint();
    }

    public void loadInspections(ProgressIndicator progress) {
    }

    public void updateInspections() {
        this.myQuickFixManager.update();
    }

    @NotNull
    protected Dimension getSceneSize(Component target) {
        int width = 0;
        int height = 0;
        if (this.myRootComponent != null) {
            Rectangle bounds = this.myRootComponent.getBounds(target);
            width = Math.max(width, (int)bounds.getMaxX());
            height = Math.max(height, (int)bounds.getMaxY());
            for (RadComponent component : this.myRootComponent.getChildren()) {
                Rectangle childBounds = component.getBounds(target);
                width = Math.max(width, (int)childBounds.getMaxX());
                height = Math.max(height, (int)childBounds.getMaxY());
            }
        }
        Dimension dimension = new Dimension(width += 50, height += 40);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/DesignerEditorPanel", "getSceneSize"));
        }
        return dimension;
    }

    private static class FixedHashMap<K, V>
    extends HashMap<K, V> {
        private final int mySize;
        private final List<K> myKeys = new LinkedList<K>();

        public FixedHashMap(int size) {
            this.mySize = size;
        }

        @Override
        public V put(K key, V value) {
            if (!this.myKeys.contains(key)) {
                if (this.myKeys.size() >= this.mySize) {
                    this.remove(this.myKeys.remove(0));
                }
                this.myKeys.add(key);
            }
            return super.put(key, value);
        }

        @Override
        public V get(Object key) {
            if (this.myKeys.contains(key)) {
                int index = this.myKeys.indexOf(key);
                int last = this.myKeys.size() - 1;
                this.myKeys.set(index, this.myKeys.get(last));
                this.myKeys.set(last, key);
            }
            return super.get(key);
        }
    }

    public static final class FixableMessageInfo {
        public final boolean myErrorIcon;
        public final String myBeforeLinkText;
        public final String myLinkText;
        public final String myAfterLinkText;
        public final Runnable myQuickFix;
        public final List<Pair<String, Runnable>> myAdditionalFixes;

        public FixableMessageInfo(boolean errorIcon, String beforeLinkText, String linkText, String afterLinkText, Runnable quickFix, List<Pair<String, Runnable>> additionalFixes) {
            this.myErrorIcon = errorIcon;
            this.myBeforeLinkText = beforeLinkText;
            this.myLinkText = linkText;
            this.myAfterLinkText = afterLinkText;
            this.myQuickFix = quickFix;
            this.myAdditionalFixes = additionalFixes;
        }
    }

    public static final class ErrorInfo {
        public String myMessage;
        public String myDisplayMessage;
        public final List<FixableMessageInfo> myMessages = new ArrayList<FixableMessageInfo>();
        public Throwable myThrowable;
        public boolean myShowMessage = true;
        public boolean myShowStack = true;
        public boolean myShowLog;
    }

    private class FixableMessageAction
    extends AbstractComboBoxAction<FixableMessageInfo> {
        private final DefaultActionGroup myActionGroup = new DefaultActionGroup();
        private String myTitle;
        private boolean myIsAdded;

        public FixableMessageAction() {
            DesignerEditorPanel.this.myActionPanel.getActionGroup().add((AnAction)this.myActionGroup);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setDescription("Warnings");
            presentation.setIcon(AllIcons.Ide.Warning_notifications);
        }

        public void show(List<FixableMessageInfo> messages) {
            if (!this.myIsAdded) {
                this.myTitle = Integer.toString(messages.size());
                this.setItems(messages, null);
                this.myActionGroup.add((AnAction)this);
                DesignerEditorPanel.this.myActionPanel.update();
                this.myIsAdded = true;
            }
        }

        public void hide() {
            if (this.myIsAdded) {
                this.myActionGroup.remove((AnAction)this);
                DesignerEditorPanel.this.myActionPanel.update();
                this.myIsAdded = false;
            }
        }

        @Override
        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup actionGroup = new DefaultActionGroup();
            for (final FixableMessageInfo message : this.myItems) {
                Object action;
                if (message.myQuickFix != null && (message.myLinkText.length() > 0 || message.myAfterLinkText.length() > 0) || message.myAdditionalFixes != null && message.myAdditionalFixes.size() > 0) {
                    final AnAction[] defaultAction = new AnAction[1];
                    DefaultActionGroup popupGroup = new DefaultActionGroup(){

                        public boolean canBePerformed(DataContext context) {
                            return true;
                        }

                        public void actionPerformed(AnActionEvent e) {
                            defaultAction[0].actionPerformed(e);
                        }
                    };
                    popupGroup.setPopup(true);
                    action = popupGroup;
                    if (message.myQuickFix != null && (message.myLinkText.length() > 0 || message.myAfterLinkText.length() > 0)) {
                        AnAction popupAction = new AnAction(){

                            public void actionPerformed(AnActionEvent e) {
                                message.myQuickFix.run();
                            }
                        };
                        popupAction.getTemplatePresentation().setText(this.cleanText(message.myLinkText + message.myAfterLinkText));
                        popupGroup.add(popupAction);
                        defaultAction[0] = popupAction;
                    }
                    if (message.myAdditionalFixes != null && message.myAdditionalFixes.size() > 0) {
                        for (final Pair<String, Runnable> pair : message.myAdditionalFixes) {
                            AnAction popupAction = new AnAction(){

                                public void actionPerformed(AnActionEvent e) {
                                    ((Runnable)pair.second).run();
                                }
                            };
                            popupAction.getTemplatePresentation().setText(this.cleanText((String)pair.first));
                            popupGroup.add(popupAction);
                            if (defaultAction[0] != null) continue;
                            defaultAction[0] = popupAction;
                        }
                    }
                } else {
                    action = new EmptyAction(true);
                }
                actionGroup.add((AnAction)action);
                this.update(message, action.getTemplatePresentation(), true);
            }
            DefaultActionGroup defaultActionGroup = actionGroup;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/designSurface/DesignerEditorPanel$FixableMessageAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        @Override
        protected void update(FixableMessageInfo item, Presentation presentation, boolean popup) {
            if (popup) {
                presentation.setText(this.cleanText(item.myBeforeLinkText));
            } else {
                presentation.setText(this.myTitle);
            }
        }

        private String cleanText(String text) {
            if (text != null) {
                text = text.trim();
                text = StringUtil.replace((String)text, (String)"&nbsp;", (String)" ");
                text = StringUtil.replace((String)text, (String)"\n", (String)" ");
                StringBuilder builder = new StringBuilder();
                int length = text.length();
                boolean whitespace = false;
                for (int i = 0; i < length; ++i) {
                    char ch = text.charAt(i);
                    if (ch == ' ') {
                        if (whitespace) continue;
                        whitespace = true;
                        builder.append(ch);
                        continue;
                    }
                    whitespace = false;
                    builder.append(ch);
                }
                text = builder.toString();
            }
            return text;
        }

        @Override
        protected boolean selectionChanged(FixableMessageInfo item) {
            return false;
        }
    }

    private final class MyLayeredPane
    extends JBLayeredPane
    implements Scrollable {
        private MyLayeredPane() {
        }

        public void doLayout() {
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                Component component = this.getComponent(i);
                component.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Rectangle bounds = DesignerEditorPanel.this.myScrollPane.getViewport().getBounds();
            Dimension size = DesignerEditorPanel.this.getSceneSize((Component)((Object)this));
            size.width = Math.max(size.width, bounds.width);
            size.height = Math.max(size.height, bounds.height);
            return size;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return visibleRect.width - 10;
            }
            return visibleRect.height - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    protected class DesignerToolProvider
    extends ToolProvider {
        protected DesignerToolProvider() {
        }

        @Override
        public void loadDefaultTool() {
            this.setActiveTool(DesignerEditorPanel.this.createDefaultTool());
        }

        @Override
        public void setActiveTool(InputTool tool) {
            if (this.getActiveTool() instanceof CreationTool && !(tool instanceof CreationTool)) {
                DesignerEditorPanel.this.getPaletteToolWindow().clearActiveItem();
            }
            if (!(tool instanceof SelectionTool)) {
                this.hideInspections();
            }
            super.setActiveTool(tool);
        }

        @Override
        public boolean execute(final ThrowableRunnable<Exception> operation, String command, final boolean updateProperties) {
            DesignerEditorPanel.this.myLastExecuteCommand = command;
            final Ref result = Ref.create((Object)Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand(DesignerEditorPanel.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    result.set((Object)DesignerEditorPanel.this.execute((ThrowableRunnable<Exception>)operation, updateProperties));
                }
            }, command, null);
            return (Boolean)result.get();
        }

        @Override
        public void executeWithReparse(final ThrowableRunnable<Exception> operation, String command) {
            DesignerEditorPanel.this.myLastExecuteCommand = command;
            CommandProcessor.getInstance().executeCommand(DesignerEditorPanel.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    DesignerEditorPanel.this.executeWithReparse((ThrowableRunnable<Exception>)operation);
                }
            }, command, null);
        }

        @Override
        public void execute(final List<EditOperation> operations, String command) {
            DesignerEditorPanel.this.myLastExecuteCommand = command;
            CommandProcessor.getInstance().executeCommand(DesignerEditorPanel.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    DesignerEditorPanel.this.execute(operations);
                }
            }, command, null);
        }

        @Override
        public void startInplaceEditing(@Nullable InplaceContext inplaceContext) {
            DesignerEditorPanel.this.myInplaceEditingLayer.startEditing(inplaceContext);
        }

        @Override
        public void hideInspections() {
            DesignerEditorPanel.this.myQuickFixManager.hideHint();
        }

        @Override
        public void showError(@NonNls String message, Throwable e) {
            DesignerEditorPanel.this.showError(message, e);
        }

        @Override
        public boolean isZoomSupported() {
            return DesignerEditorPanel.this.isZoomSupported();
        }

        @Override
        public void zoom(@NotNull ZoomType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/designer/designSurface/DesignerEditorPanel$DesignerToolProvider", "zoom"));
            }
            DesignerEditorPanel.this.zoom(type);
        }

        @Override
        public void setZoom(double zoom) {
            DesignerEditorPanel.this.setZoom(zoom);
        }

        @Override
        public double getZoom() {
            return DesignerEditorPanel.this.getZoom();
        }
    }

    protected class DesignerEditableArea
    extends ComponentEditableArea {
        public DesignerEditableArea() {
            super(DesignerEditorPanel.this.myLayeredPane);
        }

        @Override
        protected void fireSelectionChanged() {
            super.fireSelectionChanged();
            DesignerEditorPanel.this.myLayeredPane.revalidate();
            DesignerEditorPanel.this.myLayeredPane.repaint();
        }

        @Override
        public void scrollToSelection() {
            Rectangle bounds;
            List<RadComponent> selection = this.getSelection();
            if (selection.size() == 1 && (bounds = selection.get(0).getBounds(DesignerEditorPanel.this.myLayeredPane)) != null) {
                DesignerEditorPanel.this.myLayeredPane.scrollRectToVisible(bounds);
            }
        }

        @Override
        public RadComponent findTarget(int x, int y, @Nullable ComponentTargetFilter filter) {
            return DesignerEditorPanel.this.findTarget(x, y, filter);
        }

        @Override
        public InputTool findTargetTool(int x, int y) {
            return DesignerEditorPanel.this.myDecorationLayer.findTargetTool(x, y);
        }

        @Override
        public void showSelection(boolean value) {
            DesignerEditorPanel.this.myDecorationLayer.showSelection(value);
        }

        @Override
        public ComponentDecorator getRootSelectionDecorator() {
            return DesignerEditorPanel.this.getRootSelectionDecorator();
        }

        @Override
        @Nullable
        public EditOperation processRootOperation(OperationContext context) {
            return DesignerEditorPanel.this.processRootOperation(context);
        }

        @Override
        public FeedbackLayer getFeedbackLayer() {
            return DesignerEditorPanel.this.myFeedbackLayer;
        }

        @Override
        public RadComponent getRootComponent() {
            return DesignerEditorPanel.this.myRootComponent;
        }

        @Override
        public ActionGroup getPopupActions() {
            return DesignerEditorPanel.this.myActionPanel.getPopupActions(this);
        }

        @Override
        public String getPopupPlace() {
            return "GuiDesigner.EditorPopup";
        }
    }
}

