/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.utils.Cursors;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ResizeTracker
extends InputTool {
    private final int myDirection;
    private final String myDescription;
    private OperationContext myContext;
    private List<EditOperation> myOperations;
    private boolean myShowFeedback;

    public ResizeTracker(int direction, Object type, @Nullable String description) {
        this.myDirection = direction;
        this.myDescription = description;
        this.myContext = new OperationContext(type);
        this.myContext.setResizeDirection(direction);
        this.setDefaultCursor(Cursors.getResizeCursor(direction));
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    @Override
    @Nullable
    protected String getDescription() {
        return this.myDescription;
    }

    @Override
    public void deactivate() {
        this.eraseFeedback();
        this.myContext = null;
        this.myOperations = null;
        super.deactivate();
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.myState == 2) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    @Override
    protected void handleButtonDown(int button) {
        if (button == 1) {
            if (this.myState == 1) {
                this.myState = 2;
            }
        } else {
            this.myState = 4;
            this.eraseFeedback();
            this.setExecuteEnabled(false);
        }
    }

    @Override
    protected void handleButtonUp(int button) {
        if (this.myState == 3) {
            this.myState = 0;
            this.eraseFeedback();
            this.executeCommand();
        }
    }

    @Override
    protected void handleDragStarted() {
        if (this.myState == 2) {
            this.myState = 3;
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 3) {
            this.updateContext();
            this.showFeedback();
            this.updateCommand();
        }
    }

    private void showFeedback() {
        for (EditOperation operation : this.getOperations()) {
            operation.showFeedback();
        }
        this.myShowFeedback = true;
    }

    private void eraseFeedback() {
        if (this.myShowFeedback) {
            this.myShowFeedback = false;
            for (EditOperation operation : this.getOperations()) {
                operation.eraseFeedback();
            }
        }
    }

    private void executeCommand() {
        if (this.myExecuteEnabled) {
            ArrayList<EditOperation> operations = new ArrayList<EditOperation>();
            for (EditOperation operation : this.getOperations()) {
                if (!operation.canExecute()) continue;
                operations.add(operation);
            }
            this.myToolProvider.execute(operations, DesignerBundle.message("command.tool_operation", new Object[0]));
        }
    }

    private void updateCommand() {
        for (EditOperation operation : this.getOperations()) {
            if (!operation.canExecute()) continue;
            this.setExecuteEnabled(true);
            return;
        }
        this.setExecuteEnabled(false);
    }

    private void updateContext() {
        this.myContext.setArea(this.myArea);
        this.myContext.setInputEvent(this.myInputEvent);
        this.myContext.setModifiers(this.myModifiers);
        Point move = new Point();
        Dimension size = new Dimension();
        int moveDeltaWidth = this.moveDeltaWidth();
        if ((this.myDirection & 4) != 0) {
            move.x += moveDeltaWidth;
            size.width -= moveDeltaWidth;
        } else if ((this.myDirection & 8) != 0) {
            size.width += moveDeltaWidth;
        }
        int moveDeltaHeight = this.moveDeltaHeight();
        if ((this.myDirection & 1) != 0) {
            move.y += moveDeltaHeight;
            size.height -= moveDeltaHeight;
        } else if ((this.myDirection & 2) != 0) {
            size.height += moveDeltaHeight;
        }
        this.myContext.setMoveDelta(move);
        this.myContext.setSizeDelta(size);
        this.myContext.setLocation(this.getLocation());
    }

    private List<EditOperation> getOperations() {
        if (this.myOperations == null) {
            this.myContext.setComponents(new ArrayList<RadComponent>(this.myArea.getSelection()));
            this.myOperations = new ArrayList<EditOperation>();
            for (RadComponent component : this.myContext.getComponents()) {
                RadComponent parent = component.getParent();
                EditOperation operation = parent == null ? this.myArea.processRootOperation(this.myContext) : parent.getLayout().processChildOperation(this.myContext);
                if (operation == null) continue;
                this.myOperations.add(operation);
                operation.setComponent(component);
            }
        }
        return this.myOperations;
    }

    @Override
    public void keyPressed(KeyEvent event, EditableArea area) throws Exception {
        boolean changedModifiers = event.getModifiers() != this.myModifiers;
        super.keyPressed(event, area);
        if (event.getKeyCode() == 27) {
            this.myToolProvider.loadDefaultTool();
        } else if (changedModifiers) {
            this.handleKeyEvent();
        }
    }

    @Override
    public void keyReleased(KeyEvent event, EditableArea area) throws Exception {
        boolean changedModifiers = event.getModifiers() != this.myModifiers;
        super.keyReleased(event, area);
        if (changedModifiers) {
            this.handleKeyEvent();
        }
    }

    private void handleKeyEvent() {
        if (this.myContext != null) {
            this.updateContext();
            this.showFeedback();
            this.updateCommand();
        }
    }
}

