/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.util.IntPair;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TrimUtil {
    public static boolean isPunctuation(char c) {
        if (c == '_') {
            return false;
        }
        boolean isPunctuation = false;
        isPunctuation |= c >= '!' & c <= '/';
        isPunctuation |= c >= ':' & c <= '@';
        isPunctuation |= c >= '[' & c <= '`';
        return isPunctuation |= c >= '{' & c <= '~';
    }

    public static boolean isAlpha(char c) {
        return !StringUtil.isWhiteSpace((char)c) && !TrimUtil.isPunctuation(c);
    }

    @NotNull
    public static Range trim(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        start1 = TrimUtil.trimStart(text1, start1, end1);
        end1 = TrimUtil.trimEnd(text1, start1, end1);
        start2 = TrimUtil.trimStart(text2, start2, end2);
        end2 = TrimUtil.trimEnd(text2, start2, end2);
        Range range = new Range(start1, end1, start2, end2);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        return range;
    }

    @NotNull
    public static MergeRange trim(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, int start1, int start2, int start3, int end1, int end2, int end3) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (text3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text3", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        start1 = TrimUtil.trimStart(text1, start1, end1);
        end1 = TrimUtil.trimEnd(text1, start1, end1);
        start2 = TrimUtil.trimStart(text2, start2, end2);
        end2 = TrimUtil.trimEnd(text2, start2, end2);
        start3 = TrimUtil.trimStart(text3, start3, end3);
        end3 = TrimUtil.trimEnd(text3, start3, end3);
        MergeRange mergeRange = new MergeRange(start1, end1, start2, end2, start3, end3);
        if (mergeRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        return mergeRange;
    }

    @NotNull
    public static IntPair trim(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        start = TrimUtil.trimStart(text, start, end);
        end = TrimUtil.trimEnd(text, start, end);
        IntPair intPair = new IntPair(start, end);
        if (intPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        return intPair;
    }

    public static int trimStart(@NotNull CharSequence text, int start, int end) {
        char c;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/TrimUtil", "trimStart"));
        }
        while (start < end && StringUtil.isWhiteSpace((char)(c = text.charAt(start)))) {
            ++start;
        }
        return start;
    }

    public static int trimEnd(@NotNull CharSequence text, int start, int end) {
        char c;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/TrimUtil", "trimEnd"));
        }
        while (start < end && StringUtil.isWhiteSpace((char)(c = text.charAt(end - 1)))) {
            --end;
        }
        return end;
    }

    @NotNull
    public static Range expand(@NotNull List<?> text1, @NotNull List<?> text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        int count1 = TrimUtil.expandForward(text1, text2, start1, start2, end1, end2);
        int count2 = TrimUtil.expandBackward(text1, text2, start1 += count1, start2 += count1, end1, end2);
        Range range = new Range(start1, end1 -= count2, start2, end2 -= count2);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        return range;
    }

    @NotNull
    public static Range expand(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        int count1 = TrimUtil.expandForward(text1, text2, start1, start2, end1, end2);
        int count2 = TrimUtil.expandBackward(text1, text2, start1 += count1, start2 += count1, end1, end2);
        Range range = new Range(start1, end1 -= count2, start2, end2 -= count2);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        return range;
    }

    @NotNull
    public static Range expandW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandW"));
        }
        int count1 = TrimUtil.expandForwardW(text1, text2, start1, start2, end1, end2);
        int count2 = TrimUtil.expandBackwardW(text1, text2, start1 += count1, start2 += count1, end1, end2);
        Range range = new Range(start1, end1 -= count2, start2, end2 -= count2);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expandW"));
        }
        return range;
    }

    public static int expandForward(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandForward"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandForward"));
        }
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(start1)) == (c2 = text2.charAt(start2))) {
            ++start1;
            ++start2;
        }
        return start1 - oldStart1;
    }

    public static int expandForward(@NotNull List<?> text1, @NotNull List<?> text2, int start1, int start2, int end1, int end2) {
        Object c2;
        Object c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandForward"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandForward"));
        }
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.get(start1)).equals(c2 = text2.get(start2))) {
            ++start1;
            ++start2;
        }
        return start1 - oldStart1;
    }

    public static int expandForwardW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandForwardW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandForwardW"));
        }
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(start1)) == (c2 = text2.charAt(start2)) && StringUtil.isWhiteSpace((char)c1)) {
            ++start1;
            ++start2;
        }
        return start1 - oldStart1;
    }

    public static int expandBackward(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandBackward"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandBackward"));
        }
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(end1 - 1)) == (c2 = text2.charAt(end2 - 1))) {
            --end1;
            --end2;
        }
        return oldEnd1 - end1;
    }

    public static int expandBackward(@NotNull List<?> text1, @NotNull List<?> text2, int start1, int start2, int end1, int end2) {
        Object c2;
        Object c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandBackward"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandBackward"));
        }
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.get(end1 - 1)).equals(c2 = text2.get(end2 - 1))) {
            --end1;
            --end2;
        }
        return oldEnd1 - end1;
    }

    public static int expandBackwardW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        char c2;
        char c1;
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandBackwardW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandBackwardW"));
        }
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && (c1 = text1.charAt(end1 - 1)) == (c2 = text2.charAt(end2 - 1)) && StringUtil.isWhiteSpace((char)c1)) {
            --end1;
            --end2;
        }
        return oldEnd1 - end1;
    }

    public static int expandForwardW(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, int start1, int start2, int start3, int end1, int end2, int end3) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandForwardW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandForwardW"));
        }
        if (text3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text3", "com/intellij/diff/comparison/TrimUtil", "expandForwardW"));
        }
        int oldStart1 = start1;
        while (start1 < end1 && start2 < end2 && start3 < end3) {
            char c1 = text1.charAt(start1);
            char c2 = text2.charAt(start2);
            char c3 = text3.charAt(start3);
            if (c1 != c2 || c1 != c3 || !StringUtil.isWhiteSpace((char)c1)) break;
            ++start1;
            ++start2;
            ++start3;
        }
        return start1 - oldStart1;
    }

    public static int expandBackwardW(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, int start1, int start2, int start3, int end1, int end2, int end3) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandBackwardW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandBackwardW"));
        }
        if (text3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text3", "com/intellij/diff/comparison/TrimUtil", "expandBackwardW"));
        }
        int oldEnd1 = end1;
        while (start1 < end1 && start2 < end2 && start3 < end3) {
            char c1 = text1.charAt(end1 - 1);
            char c2 = text2.charAt(end2 - 1);
            char c3 = text3.charAt(end3 - 1);
            if (c1 != c2 || c1 != c3 || !StringUtil.isWhiteSpace((char)c1)) break;
            --end1;
            --end2;
            --end3;
        }
        return oldEnd1 - end1;
    }

    @NotNull
    public static IntPair expandForwardIW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandForwardIW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandForwardIW"));
        }
        while (start1 < end1 && start2 < end2) {
            char c2;
            char c1 = text1.charAt(start1);
            if (c1 == (c2 = text2.charAt(start2))) {
                ++start1;
                ++start2;
                continue;
            }
            boolean skipped = false;
            if (StringUtil.isWhiteSpace((char)c1)) {
                skipped = true;
                ++start1;
            }
            if (StringUtil.isWhiteSpace((char)c2)) {
                skipped = true;
                ++start2;
            }
            if (skipped) continue;
            break;
        }
        start1 = TrimUtil.trimStart(text1, start1, end1);
        start2 = TrimUtil.trimStart(text2, start2, end2);
        IntPair intPair = new IntPair(start1, start2);
        if (intPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expandForwardIW"));
        }
        return intPair;
    }

    @NotNull
    public static IntPair expandBackwardIW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandBackwardIW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandBackwardIW"));
        }
        while (start1 < end1 && start2 < end2) {
            char c2;
            char c1 = text1.charAt(end1 - 1);
            if (c1 == (c2 = text2.charAt(end2 - 1))) {
                --end1;
                --end2;
                continue;
            }
            boolean skipped = false;
            if (StringUtil.isWhiteSpace((char)c1)) {
                skipped = true;
                --end1;
            }
            if (StringUtil.isWhiteSpace((char)c2)) {
                skipped = true;
                --end2;
            }
            if (skipped) continue;
            break;
        }
        end1 = TrimUtil.trimEnd(text1, start1, end1);
        end2 = TrimUtil.trimEnd(text2, start2, end2);
        IntPair intPair = new IntPair(end1, end2);
        if (intPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expandBackwardIW"));
        }
        return intPair;
    }

    @NotNull
    public static Range expandIW(@NotNull CharSequence text1, @NotNull CharSequence text2, int start1, int start2, int end1, int end2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        IntPair start = TrimUtil.expandForwardIW(text1, text2, start1, start2, end1, end2);
        start1 = start.val1;
        start2 = start.val2;
        IntPair end = TrimUtil.expandBackwardIW(text1, text2, start1, start2, end1, end2);
        end1 = end.val1;
        end2 = end.val2;
        Range range = new Range(start1, end1, start2, end2);
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        return range;
    }

    @NotNull
    public static Range expand(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range range) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        Range range2 = TrimUtil.expand(text1, text2, range.start1, range.start2, range.end1, range.end2);
        if (range2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expand"));
        }
        return range2;
    }

    @NotNull
    public static Range trim(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull Range range) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        Range range2 = TrimUtil.trim(text1, text2, range.start1, range.start2, range.end1, range.end2);
        if (range2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        return range2;
    }

    @NotNull
    public static MergeRange trim(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull MergeRange range) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (text3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text3", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        MergeRange mergeRange = TrimUtil.trim(text1, text2, text3, range.start1, range.start2, range.start3, range.end1, range.end2, range.end3);
        if (mergeRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "trim"));
        }
        return mergeRange;
    }

    @NotNull
    public static Range expandIW(@NotNull CharSequence text1, @NotNull CharSequence text2) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        Range range = TrimUtil.expandIW(text1, text2, 0, 0, text1.length(), text2.length());
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TrimUtil", "expandIW"));
        }
        return range;
    }
}

