/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.dir;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.DataManager;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.JarFileDiffElement;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirDiffViewer
implements FrameDiffTool.DiffViewer {
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final ContentDiffRequest myRequest;
    @NotNull
    private final DirDiffPanel myDirDiffPanel;
    @NotNull
    private final JPanel myPanel;

    public DirDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/dir/DirDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/dir/DirDiffViewer", "<init>"));
        }
        UsageTrigger.trigger("diff.DirDiffViewer");
        this.myContext = context;
        this.myRequest = request;
        List contents = request.getContents();
        DiffElement element1 = DirDiffViewer.createDiffElement((DiffContent)contents.get(0));
        DiffElement element2 = DirDiffViewer.createDiffElement((DiffContent)contents.get(1));
        Project project2 = context.getProject();
        if (project2 == null) {
            project2 = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        DirDiffTableModel model = new DirDiffTableModel(project2, element1, element2, new DirDiffSettings());
        this.myDirDiffPanel = new DirDiffPanel(model, new DirDiffWindow(null){

            @Override
            public Window getWindow() {
                return null;
            }

            @Override
            public Disposable getDisposable() {
                return DirDiffViewer.this;
            }

            @Override
            public void setTitle(String title) {
            }
        });
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.myDirDiffPanel.getPanel(), "Center");
        DataManager.registerDataProvider((JComponent)this.myPanel, (DataProvider)new DataProvider(){

            public Object getData(@NonNls String dataId) {
                if (PlatformDataKeys.HELP_ID.is(dataId)) {
                    return "reference.dialogs.diff.folder";
                }
                return DirDiffViewer.this.myDirDiffPanel.getData(dataId);
            }
        });
    }

    @NotNull
    public FrameDiffTool.ToolbarComponents init() {
        this.myDirDiffPanel.setupSplitter();
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = Collections.singletonList(new DefaultActionGroup(this.myDirDiffPanel.getActions()));
        components.statusPanel = this.myDirDiffPanel.extractFilterPanel();
        FrameDiffTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DirDiffViewer", "init"));
        }
        return toolbarComponents;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDirDiffPanel);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DirDiffViewer", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myDirDiffPanel.getTable();
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/dir/DirDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/dir/DirDiffViewer", "canShowRequest"));
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2) {
            return false;
        }
        if (!DirDiffViewer.canShowContent((DiffContent)contents.get(0))) {
            return false;
        }
        if (!DirDiffViewer.canShowContent((DiffContent)contents.get(1))) {
            return false;
        }
        return !(contents.get(0) instanceof EmptyContent) || !(contents.get(1) instanceof EmptyContent);
    }

    private static boolean canShowContent(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/dir/DirDiffViewer", "canShowContent"));
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DirectoryContent) {
            return true;
        }
        return content instanceof FileContent && content.getContentType() instanceof ArchiveFileType && ((FileContent)content).getFile().isValid() && ((FileContent)content).getFile().isInLocalFileSystem();
    }

    @NotNull
    private static DiffElement createDiffElement(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/dir/DirDiffViewer", "createDiffElement"));
        }
        if (content instanceof EmptyContent) {
            DiffElement diffElement = new DiffElement(){

                public String getPath() {
                    return "";
                }

                @NotNull
                public String getName() {
                    if ("Nothing" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DirDiffViewer$3", "getName"));
                    }
                    return "Nothing";
                }

                public long getSize() {
                    return -1L;
                }

                public long getTimeStamp() {
                    return -1L;
                }

                public boolean isContainer() {
                    return true;
                }

                public DiffElement[] getChildren() throws IOException {
                    return EMPTY_ARRAY;
                }

                public byte[] getContent() throws IOException {
                    return null;
                }

                public Object getValue() {
                    return null;
                }
            };
            if (diffElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DirDiffViewer", "createDiffElement"));
            }
            return diffElement;
        }
        if (content instanceof DirectoryContent) {
            VirtualFileDiffElement virtualFileDiffElement = new VirtualFileDiffElement(((DirectoryContent)content).getFile());
            if (virtualFileDiffElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DirDiffViewer", "createDiffElement"));
            }
            return virtualFileDiffElement;
        }
        if (content instanceof FileContent && content.getContentType() instanceof ArchiveFileType) {
            JarFileDiffElement jarFileDiffElement = new JarFileDiffElement(((FileContent)content).getFile());
            if (jarFileDiffElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/dir/DirDiffViewer", "createDiffElement"));
            }
            return jarFileDiffElement;
        }
        throw new IllegalArgumentException(content.getClass() + " " + content.getContentType());
    }
}

