/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.HighlightingLevel;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Key;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TextDiffSettings", storages={@Storage(value="diff.xml")})
public class TextDiffSettingsHolder
implements PersistentStateComponent<State> {
    public static final Key<TextDiffSettings> KEY = Key.create((String)"TextDiffSettings");
    public static final int[] CONTEXT_RANGE_MODES = new int[]{1, 2, 4, 8, -1};
    public static final String[] CONTEXT_RANGE_MODE_LABELS = new String[]{"1", "2", "4", "8", "Disable"};
    private State myState = new State();

    @NotNull
    public TextDiffSettings getSettings(@Nullable String place) {
        PlaceSettings placeSettings;
        if (place == null) {
            place = "Default";
        }
        if ((placeSettings = this.myState.PLACES_MAP.get(place)) == null) {
            placeSettings = new PlaceSettings();
            this.myState.PLACES_MAP.put(place, placeSettings);
        }
        TextDiffSettings textDiffSettings = new TextDiffSettings(this.myState.SHARED_SETTINGS, placeSettings);
        if (textDiffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder", "getSettings"));
        }
        return textDiffSettings;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder", "getState"));
        }
        return state;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static TextDiffSettingsHolder getInstance() {
        return (TextDiffSettingsHolder)ServiceManager.getService(TextDiffSettingsHolder.class);
    }

    @NotNull
    public static Map<String, PlaceSettings> getDefaultPlaceSettings() {
        TreeMap<String, PlaceSettings> map = new TreeMap<String, PlaceSettings>();
        PlaceSettings changes = new PlaceSettings();
        changes.EXPAND_BY_DEFAULT = false;
        PlaceSettings commit = new PlaceSettings();
        commit.EXPAND_BY_DEFAULT = false;
        map.put("Default", new PlaceSettings());
        map.put("ChangesView", changes);
        map.put("CommitDialog", commit);
        TreeMap<String, PlaceSettings> treeMap = map;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder", "getDefaultPlaceSettings"));
        }
        return treeMap;
    }

    public static class State {
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, PlaceSettings> PLACES_MAP = TextDiffSettingsHolder.getDefaultPlaceSettings();
        public SharedSettings SHARED_SETTINGS = new SharedSettings();
    }

    public static class TextDiffSettings {
        @NotNull
        public SharedSettings SHARED_SETTINGS;
        @NotNull
        public PlaceSettings PLACE_SETTINGS;

        public TextDiffSettings() {
            this.SHARED_SETTINGS = new SharedSettings();
            this.PLACE_SETTINGS = new PlaceSettings();
        }

        public TextDiffSettings(@NotNull SharedSettings SHARED_SETTINGS, @NotNull PlaceSettings PLACE_SETTINGS) {
            if (SHARED_SETTINGS == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "SHARED_SETTINGS", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings", "<init>"));
            }
            if (PLACE_SETTINGS == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "PLACE_SETTINGS", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings", "<init>"));
            }
            this.SHARED_SETTINGS = new SharedSettings();
            this.PLACE_SETTINGS = new PlaceSettings();
            this.SHARED_SETTINGS = SHARED_SETTINGS;
            this.PLACE_SETTINGS = PLACE_SETTINGS;
        }

        public boolean isEnableSyncScroll() {
            return this.PLACE_SETTINGS.ENABLE_SYNC_SCROLL;
        }

        public void setEnableSyncScroll(boolean value) {
            this.PLACE_SETTINGS.ENABLE_SYNC_SCROLL = value;
        }

        @NotNull
        public HighlightPolicy getHighlightPolicy() {
            HighlightPolicy highlightPolicy = this.PLACE_SETTINGS.HIGHLIGHT_POLICY;
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings", "getHighlightPolicy"));
            }
            return highlightPolicy;
        }

        public void setHighlightPolicy(@NotNull HighlightPolicy value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings", "setHighlightPolicy"));
            }
            this.PLACE_SETTINGS.HIGHLIGHT_POLICY = value;
        }

        @NotNull
        public IgnorePolicy getIgnorePolicy() {
            IgnorePolicy ignorePolicy = this.PLACE_SETTINGS.IGNORE_POLICY;
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings", "getIgnorePolicy"));
            }
            return ignorePolicy;
        }

        public void setIgnorePolicy(@NotNull IgnorePolicy policy) {
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings", "setIgnorePolicy"));
            }
            this.PLACE_SETTINGS.IGNORE_POLICY = policy;
        }

        public boolean isShowLineNumbers() {
            return this.PLACE_SETTINGS.SHOW_LINE_NUMBERS;
        }

        public void setShowLineNumbers(boolean state) {
            this.PLACE_SETTINGS.SHOW_LINE_NUMBERS = state;
        }

        public boolean isShowWhitespaces() {
            return this.PLACE_SETTINGS.SHOW_WHITESPACES;
        }

        public void setShowWhiteSpaces(boolean state) {
            this.PLACE_SETTINGS.SHOW_WHITESPACES = state;
        }

        public boolean isShowIndentLines() {
            return this.PLACE_SETTINGS.SHOW_INDENT_LINES;
        }

        public void setShowIndentLines(boolean state) {
            this.PLACE_SETTINGS.SHOW_INDENT_LINES = state;
        }

        public boolean isUseSoftWraps() {
            return this.PLACE_SETTINGS.USE_SOFT_WRAPS;
        }

        public void setUseSoftWraps(boolean state) {
            this.PLACE_SETTINGS.USE_SOFT_WRAPS = state;
        }

        @NotNull
        public HighlightingLevel getHighlightingLevel() {
            HighlightingLevel highlightingLevel = this.PLACE_SETTINGS.HIGHLIGHTING_LEVEL;
            if (highlightingLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings", "getHighlightingLevel"));
            }
            return highlightingLevel;
        }

        public void setHighlightingLevel(@NotNull HighlightingLevel state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings", "setHighlightingLevel"));
            }
            this.PLACE_SETTINGS.HIGHLIGHTING_LEVEL = state;
        }

        public int getContextRange() {
            return this.SHARED_SETTINGS.CONTEXT_RANGE;
        }

        public void setContextRange(int value) {
            this.SHARED_SETTINGS.CONTEXT_RANGE = value;
        }

        public boolean isExpandByDefault() {
            return this.PLACE_SETTINGS.EXPAND_BY_DEFAULT;
        }

        public void setExpandByDefault(boolean value) {
            this.PLACE_SETTINGS.EXPAND_BY_DEFAULT = value;
        }

        public boolean isReadOnlyLock() {
            return this.PLACE_SETTINGS.READ_ONLY_LOCK;
        }

        public void setReadOnlyLock(boolean state) {
            this.PLACE_SETTINGS.READ_ONLY_LOCK = state;
        }

        @NotNull
        public static TextDiffSettings getSettings() {
            TextDiffSettings textDiffSettings = TextDiffSettings.getSettings(null);
            if (textDiffSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings", "getSettings"));
            }
            return textDiffSettings;
        }

        @NotNull
        public static TextDiffSettings getSettings(@Nullable String place) {
            TextDiffSettings textDiffSettings = TextDiffSettingsHolder.getInstance().getSettings(place);
            if (textDiffSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings", "getSettings"));
            }
            return textDiffSettings;
        }
    }

    private static class PlaceSettings {
        public HighlightPolicy HIGHLIGHT_POLICY = HighlightPolicy.BY_WORD;
        public IgnorePolicy IGNORE_POLICY = IgnorePolicy.DEFAULT;
        public boolean ENABLE_SYNC_SCROLL = true;
        public boolean SHOW_WHITESPACES = false;
        public boolean SHOW_LINE_NUMBERS = true;
        public boolean SHOW_INDENT_LINES = false;
        public boolean USE_SOFT_WRAPS = false;
        public HighlightingLevel HIGHLIGHTING_LEVEL = HighlightingLevel.INSPECTIONS;
        public boolean READ_ONLY_LOCK = true;
        public boolean EXPAND_BY_DEFAULT = true;

        private PlaceSettings() {
        }
    }

    private static final class SharedSettings {
        public int CONTEXT_RANGE = 4;

        private SharedSettings() {
        }
    }
}

