/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DiffLineMarkerRenderer
implements LineMarkerRendererEx {
    @NotNull
    private final RangeHighlighter myHighlighter;
    @NotNull
    private final TextDiffType myDiffType;
    private final boolean myIgnoredFoldingOutline;
    private final boolean myResolved;
    private final boolean myEmptyRange;
    private final boolean myLastLine;

    public DiffLineMarkerRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType diffType, boolean ignoredFoldingOutline, boolean resolved, boolean isEmptyRange, boolean isLastLine) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/util/DiffLineMarkerRenderer", "<init>"));
        }
        if (diffType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffType", "com/intellij/diff/util/DiffLineMarkerRenderer", "<init>"));
        }
        this.myHighlighter = highlighter;
        this.myDiffType = diffType;
        this.myIgnoredFoldingOutline = ignoredFoldingOutline;
        this.myResolved = resolved;
        this.myEmptyRange = isEmptyRange;
        this.myLastLine = isLastLine;
    }

    public void paint(Editor editor, Graphics g, Rectangle range) {
        int height;
        int y;
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        Graphics2D g2 = (Graphics2D)g;
        int x1 = 0;
        int x2 = x1 + gutter.getWidth();
        if (this.myEmptyRange && this.myLastLine) {
            y = DiffDrawUtil.lineToY(editor, DiffUtil.getLineCount(editor.getDocument()));
            height = 0;
        } else {
            int startLine = editor.getDocument().getLineNumber(this.myHighlighter.getStartOffset());
            int endLine = editor.getDocument().getLineNumber(this.myHighlighter.getEndOffset()) + 1;
            y = DiffDrawUtil.lineToY(editor, startLine);
            height = this.myEmptyRange ? 0 : DiffDrawUtil.lineToY(editor, endLine) - y;
        }
        int annotationsOffset = gutter.getAnnotationsAreaOffset();
        int annotationsWidth = gutter.getAnnotationsAreaWidth();
        if (annotationsWidth != 0) {
            this.drawMarker(editor, g2, x1, annotationsOffset, y, height, false);
            x1 = annotationsOffset + annotationsWidth;
        }
        if (this.myIgnoredFoldingOutline) {
            int xOutline = gutter.getWhitespaceSeparatorOffset();
            this.drawMarker(editor, g2, xOutline, x2, y, height, true);
            this.drawMarker(editor, g2, x1, xOutline, y, height, false);
        } else {
            this.drawMarker(editor, g2, x1, x2, y, height, false);
        }
    }

    private void drawMarker(Editor editor, Graphics2D g2, int x1, int x2, int y, int height, boolean ignoredOutline) {
        Color color = this.myDiffType.getColor(editor);
        if (height > 2) {
            if (ignoredOutline) {
                g2.setColor(this.myDiffType.getIgnoredColor(editor));
            } else {
                g2.setColor(color);
            }
            if (!this.myResolved) {
                g2.fillRect(x1, y, x2 - x1, height);
            }
            DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y - 1, color, false, this.myResolved);
            DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y + height - 1, color, false, this.myResolved);
        } else {
            DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y - 1, color, true, this.myResolved);
        }
    }

    @Override
    public LineMarkerRendererEx.Position getPosition() {
        return LineMarkerRendererEx.Position.CUSTOM;
    }
}

