/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDiffTypeFactory {
    @NotNull
    public static final TextDiffTypeImpl INSERTED = new TextDiffTypeImpl(DiffColors.DIFF_INSERTED, DiffBundle.message((String)"diff.type.inserted.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl DELETED = new TextDiffTypeImpl(DiffColors.DIFF_DELETED, DiffBundle.message((String)"diff.type.deleted.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl MODIFIED = new TextDiffTypeImpl(DiffColors.DIFF_MODIFIED, DiffBundle.message((String)"diff.type.changed.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl CONFLICT = new TextDiffTypeImpl(DiffColors.DIFF_CONFLICT, DiffBundle.message((String)"diff.type.conflict.name", (Object[])new Object[0]));
    private static final TextDiffTypeFactory ourInstance = new TextDiffTypeFactory();
    private final List<TextDiffTypeImpl> myTypes = new ArrayList<TextDiffTypeImpl>();
    private static final double MIDDLE_COLOR_FACTOR = 0.6;

    private TextDiffTypeFactory() {
        ContainerUtil.addAll(this.myTypes, (Object[])new TextDiffTypeImpl[]{INSERTED, DELETED, MODIFIED, CONFLICT});
    }

    @NotNull
    public synchronized TextDiffType createTextDiffType(@NonNls @NotNull TextAttributesKey key, @NotNull String name) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/TextDiffTypeFactory", "createTextDiffType"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/util/TextDiffTypeFactory", "createTextDiffType"));
        }
        TextDiffTypeImpl type = new TextDiffTypeImpl(key, name);
        this.myTypes.add(type);
        TextDiffTypeImpl textDiffTypeImpl = type;
        if (textDiffTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory", "createTextDiffType"));
        }
        return textDiffTypeImpl;
    }

    public synchronized TextDiffTypeImpl[] getAllDiffTypes() {
        return this.myTypes.toArray(new TextDiffTypeImpl[this.myTypes.size()]);
    }

    public static TextDiffTypeFactory getInstance() {
        return ourInstance;
    }

    @NotNull
    public static Color getMiddleColor(@NotNull Color fg, @NotNull Color bg) {
        if (fg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fg", "com/intellij/diff/util/TextDiffTypeFactory", "getMiddleColor"));
        }
        if (bg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bg", "com/intellij/diff/util/TextDiffTypeFactory", "getMiddleColor"));
        }
        int red = TextDiffTypeFactory.avg(fg.getRed(), bg.getRed(), 0.6);
        int green = TextDiffTypeFactory.avg(fg.getGreen(), bg.getGreen(), 0.6);
        int blue = TextDiffTypeFactory.avg(fg.getBlue(), bg.getBlue(), 0.6);
        Color color = new Color(red, green, blue);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory", "getMiddleColor"));
        }
        return color;
    }

    private static int avg(int fg, int bg, double factor) {
        return (int)((long)fg + Math.round(factor * (double)(bg - fg)));
    }

    public static class TextDiffTypeImpl
    implements TextDiffType {
        @NotNull
        private final TextAttributesKey myKey;
        @NotNull
        private final String myName;

        public TextDiffTypeImpl(@NotNull TextAttributesKey key, @NotNull String name) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "<init>"));
            }
            this.myKey = key;
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getName"));
            }
            return string;
        }

        @NotNull
        public TextAttributes getAttributes(@Nullable Editor editor) {
            if (editor == null) {
                TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(this.myKey);
                if (textAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getAttributes"));
                }
                return textAttributes;
            }
            TextAttributes textAttributes = editor.getColorsScheme().getAttributes(this.myKey);
            if (textAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getAttributes"));
            }
            return textAttributes;
        }

        @Override
        @NotNull
        public Color getColor(@Nullable Editor editor) {
            Color color = this.getAttributes(editor).getBackgroundColor();
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getColor"));
            }
            return color;
        }

        @Override
        @NotNull
        public Color getIgnoredColor(@Nullable Editor editor) {
            TextAttributes attributes = this.getAttributes(editor);
            Color color = attributes.getForegroundColor();
            if (color != null) {
                Color color2 = color;
                if (color2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getIgnoredColor"));
                }
                return color2;
            }
            if (editor instanceof EditorEx) {
                Color fg = attributes.getBackgroundColor();
                Color bg = ((EditorEx)editor).getBackgroundColor();
                Color color3 = TextDiffTypeFactory.getMiddleColor(fg, bg);
                if (color3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getIgnoredColor"));
                }
                return color3;
            }
            Color fg = attributes.getBackgroundColor();
            Color bg = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            Color color4 = TextDiffTypeFactory.getMiddleColor(fg, bg);
            if (color4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getIgnoredColor"));
            }
            return color4;
        }

        @Override
        @Nullable
        public Color getMarkerColor(@Nullable Editor editor) {
            return this.getAttributes(editor).getErrorStripeColor();
        }

        @NotNull
        public TextAttributesKey getKey() {
            TextAttributesKey textAttributesKey = this.myKey;
            if (textAttributesKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl", "getKey"));
            }
            return textAttributesKey;
        }

        public String toString() {
            return this.myName;
        }
    }
}

