/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TreeComparator {
    private TreeComparator() {
    }

    public static boolean areEqual(@NotNull PsiElement x, @NotNull PsiElement y, NodeSpecificHasher hasher, int discardCost) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/intellij/dupLocator/TreeComparator", "areEqual"));
        }
        if (y == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "y", "com/intellij/dupLocator/TreeComparator", "areEqual"));
        }
        int costX = hasher.getNodeCost(x);
        int costY = hasher.getNodeCost(y);
        if (costX == -1 || costY == -1) {
            return false;
        }
        if (costX < discardCost || costY < discardCost) {
            return true;
        }
        if (hasher.areNodesEqual(x, y)) {
            if (!hasher.checkDeep(x, y)) {
                return true;
            }
            List<PsiElement> xSons = hasher.getNodeChildren(x);
            List<PsiElement> ySons = hasher.getNodeChildren(y);
            if (xSons.size() == ySons.size()) {
                for (int i = 0; i < ySons.size(); ++i) {
                    if (TreeComparator.areEqual(xSons.get(i), ySons.get(i), hasher, discardCost)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

