/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.ExternalizableDuplocatorState;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.NodeSpecificHasherBase;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DuplicatesProfileBase
extends DuplicatesProfile {
    @Override
    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/dupLocator/treeHash/DuplicatesProfileBase", "createVisitor"));
        }
        NodeSpecificHasherBase nodeSpecificHasherBase = new NodeSpecificHasherBase(DuplocatorSettings.getInstance(), collector, this);
        if (nodeSpecificHasherBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/DuplicatesProfileBase", "createVisitor"));
        }
        return nodeSpecificHasherBase;
    }

    public abstract int getNodeCost(@NotNull PsiElement var1);

    public TokenSet getLiterals() {
        return TokenSet.EMPTY;
    }

    @Override
    @NotNull
    public ExternalizableDuplocatorState getDuplocatorState(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/treeHash/DuplicatesProfileBase", "getDuplocatorState"));
        }
        ExternalizableDuplocatorState externalizableDuplocatorState = DuplocatorUtil.registerAndGetState(language);
        if (externalizableDuplocatorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/treeHash/DuplicatesProfileBase", "getDuplocatorState"));
        }
        return externalizableDuplocatorState;
    }

    @Override
    public boolean isMyDuplicate(@NotNull DupInfo info, int index) {
        PsiElement first;
        PsiElement[] elements;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/dupLocator/treeHash/DuplicatesProfileBase", "isMyDuplicate"));
        }
        PsiFragment[] fragments = info.getFragmentOccurences(index);
        if (fragments.length > 0 && (elements = fragments[0].getElements()).length > 0 && (first = elements[0]) != null) {
            Language language = first.getLanguage();
            return this.isMyLanguage(language);
        }
        return false;
    }

    @Override
    @Nullable
    public PsiElementRole getRole(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/treeHash/DuplicatesProfileBase", "getRole"));
        }
        return null;
    }
}

