/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.ide.scratch.RootType;
import com.intellij.openapi.util.text.StringHash;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConsoleRootType
extends RootType {
    public static final String SEPARATOR = "-. . -..- - / . -. - .-. -.--";
    private static final String PATH_PREFIX = "consoles/";

    protected ConsoleRootType(@NotNull String consoleTypeId, @Nullable String displayName) {
        if (consoleTypeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleTypeId", "com/intellij/execution/console/ConsoleRootType", "<init>"));
        }
        super(PATH_PREFIX + consoleTypeId, displayName);
    }

    public final String getConsoleTypeId() {
        return this.getId().substring(PATH_PREFIX.length());
    }

    @NotNull
    public String getEntrySeparator() {
        if ("\n-. . -..- - / . -. - .-. -.--\n" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleRootType", "getEntrySeparator"));
        }
        return "\n-. . -..- - / . -. - .-. -.--\n";
    }

    @NotNull
    public String getContentPathName(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/console/ConsoleRootType", "getContentPathName"));
        }
        String string = Long.toHexString(StringHash.calc((String)id));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleRootType", "getContentPathName"));
        }
        return string;
    }

    @NotNull
    public String getHistoryPathName(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/console/ConsoleRootType", "getHistoryPathName"));
        }
        String string = Long.toHexString(StringHash.calc((String)id));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleRootType", "getHistoryPathName"));
        }
        return string;
    }

    @NotNull
    public String getDefaultFileExtension() {
        if ("txt" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/console/ConsoleRootType", "getDefaultFileExtension"));
        }
        return "txt";
    }
}

