/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jar;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.jar.JarApplicationConfiguration;
import com.intellij.execution.jar.JarApplicationConfigurationType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public class JarApplicationConfigurationProducer
extends RunConfigurationProducer<JarApplicationConfiguration> {
    public JarApplicationConfigurationProducer() {
        super((ConfigurationType)JarApplicationConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(JarApplicationConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        VirtualFile file2 = JarApplicationConfigurationProducer.getJarFileFromContext(context);
        if (file2 != null) {
            configuration.setName(file2.getName());
            configuration.setJarPath(file2.getPath());
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getJarFileFromContext(ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        VirtualFile file2 = location.getVirtualFile();
        return file2 != null && FileUtilRt.extensionEquals((String)file2.getName(), (String)"jar") ? file2 : null;
    }

    public boolean isConfigurationFromContext(JarApplicationConfiguration configuration, ConfigurationContext context) {
        VirtualFile file2 = JarApplicationConfigurationProducer.getJarFileFromContext(context);
        return file2 != null && FileUtil.pathsEqual((String)file2.getPath(), (String)configuration.getJarPath());
    }
}

